/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.internal.transformer

import org.objectweb.asm.Opcodes
import org.objectweb.asm.tree.ClassNode
import org.objectweb.asm.tree.InsnList
import org.objectweb.asm.tree.InsnNode
import org.objectweb.asm.tree.MethodInsnNode
import org.objectweb.asm.tree.VarInsnNode

/**
 * Created by ChengTao(chentao.joe@bytedance.com) on 2022/9/7.
 */
internal class LayoutCreatorFactoryRegistryTransformer : ClassTransformer {
    override fun transform(klass: ClassNode) {
        if (klass.name == LAYOUT_CREATOR_FACTORY_REGISTRY) {
            klass.methods.find {
                it.name == METHOD_GET_BY_LAYOUT_ID && it.desc == METHOD_GET_BY_LAYOUT_ID_DESC
            }?.instructions?.also { it.clear() }?.add(InsnList().apply {
                add(VarInsnNode(Opcodes.ILOAD, 0))
                add(
                    MethodInsnNode(
                        Opcodes.INVOKESTATIC,
                        LAYOUT_CREATOR_FACTORY_REGISTRY_IMPL,
                        METHOD_GET_BY_LAYOUT_ID,
                        METHOD_GET_BY_LAYOUT_ID_DESC,
                        false
                    )
                )
                add(InsnNode(Opcodes.ARETURN))
            })
        }
    }

    companion object {
        private const val LAYOUT_CREATOR_FACTORY_REGISTRY =
            "com/bytedance/ultimate/inflater/internal/spi/LayoutCreatorFactoryRegistry"
        private const val LAYOUT_CREATOR_FACTORY_REGISTRY_IMPL =
            "com/bytedance/ultimate/inflater/internal/spi/LayoutCreatorFactoryRegistryImpl"
        private const val LAYOUT_CREATOR_FACTORY =
            "com/bytedance/ultimate/inflater/ui/LayoutCreator\$Factory"
        private const val METHOD_GET_BY_LAYOUT_ID = "getByLayoutId"
        private const val METHOD_GET_BY_LAYOUT_ID_DESC = "(I)L$LAYOUT_CREATOR_FACTORY;"
    }
}