/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.internal.transformer

import org.objectweb.asm.Opcodes
import org.objectweb.asm.tree.ClassNode
import org.objectweb.asm.tree.InsnList
import org.objectweb.asm.tree.InsnNode
import org.objectweb.asm.tree.MethodInsnNode

/**
 * Created by ChengTao(chentao.joe@bytedance.com) on 2022/9/19.
 */
internal class UltimateInflaterApplicationThemeTransformer : ClassTransformer {

    override fun transform(klass: ClassNode) {
        if (klass.name == ULTIMATE_INFLATER_APPLICATION_THEME) {
            klass.methods
                .find { it.name == "getThemeId" && it.desc == "()I" }
                ?.instructions?.also { it.clear() }?.add(InsnList().apply {
                    // return UltimateInflaterApplicationThemeImpl.getThemeId();
                    add(
                        MethodInsnNode(
                            Opcodes.INVOKESTATIC,
                            ULTIMATE_INFLATER_APPLICATION_THEME_IMPL,
                            "getThemeId",
                            "()I",
                            false
                        )
                    )
                    add(InsnNode(Opcodes.IRETURN))
                })
        }
    }

    companion object {
        private const val ULTIMATE_INFLATER_APPLICATION_THEME =
            "com/bytedance/ultimate/inflater/internal/context/UltimateInflaterApplicationTheme"
        private const val ULTIMATE_INFLATER_APPLICATION_THEME_IMPL =
            "com/bytedance/ultimate/inflater/internal/context/UltimateInflaterApplicationThemeImpl"
    }
}