/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.internal.transformer

import org.objectweb.asm.Opcodes
import org.objectweb.asm.tree.*

/**
 * Created by chentao.joe on 2022/7/29
 * @author chentao.joe@bytedance.com
 */
internal class ViewHelperTransformer : ClassTransformer {
    override fun transform(klass: ClassNode) {
        if (klass.name == VIEW_HELPER) {
            klass.methods.find {
                it.name == "updateContextDirectly" && it.desc == "(L$VIEW;L$CONTEXT;)V"
            }?.instructions?.also { it.clear() }?.add(InsnList().apply {
                add(VarInsnNode(Opcodes.ALOAD, 0))
                add(VarInsnNode(Opcodes.ALOAD, 1))
                add(FieldInsnNode(Opcodes.PUTFIELD, VIEW, "mContext", "L$CONTEXT;"))
                add(InsnNode(Opcodes.RETURN))
            })
        }
    }

    companion object {
        private const val VIEW_HELPER = "android/view/UltimateInflaterViewHelper"
        private const val VIEW = "android/view/View"
        private const val CONTEXT = "android/content/Context"
    }
}
