/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.internal.transformer

import org.objectweb.asm.Opcodes
import org.objectweb.asm.tree.*

/**
 * Created by chentao.joe on 2022/7/29
 * @author chentao.joe@bytedance.com
 */
internal class XmlBlockHelperTransformer : ClassTransformer {
    override fun transform(klass: ClassNode) {
        if (klass.name == XML_BLOCK_HELPER) {
            klass.methods.find {
                it.name == "createAttributeSetDirectly" && it.desc == "([B)L$ATTRIBUTE_SET;"
            }?.instructions?.also { it.clear() }?.add(InsnList().apply {
                // 1. new XmlBlock()
                add(TypeInsnNode(Opcodes.NEW, XML_BLOCK))
                add(InsnNode(Opcodes.DUP))
                add(VarInsnNode(Opcodes.ALOAD, 0))
                add(
                    MethodInsnNode(
                        Opcodes.INVOKESPECIAL,
                        XML_BLOCK,
                        "<init>",
                        "([B)V",
                        false
                    )
                )
                // 2. XmlBlock#newParser
                add(
                    MethodInsnNode(
                        Opcodes.INVOKEVIRTUAL,
                        XML_BLOCK,
                        "newParser",
                        "()L$XML_RESOURCE_PARSER;",
                        false
                    )
                )
                add(TypeInsnNode(Opcodes.CHECKCAST, ATTRIBUTE_SET))
                add(InsnNode(Opcodes.ARETURN))
            })
        }
    }

    companion object {
        private const val XML_BLOCK_HELPER = "android/content/res/UltimateInflaterXmlBlockHelper"
        private const val XML_BLOCK = "android/content/res/XmlBlock"
        private const val ATTRIBUTE_SET = "android/util/AttributeSet"
        private const val XML_RESOURCE_PARSER = "android/content/res/XmlResourceParser"
    }
}
