/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

public final class UltimateInflaterXmlBlockHelper {
    private static final String TAG = "XmlBlockHelper";
    private static final String XML_BLOCK_CLASS = "android.content.res.XmlBlock";
    private static volatile Constructor<?> xmlBlockConstructor;
    private static volatile Method newParserMethod;

    private UltimateInflaterXmlBlockHelper() {
        throw new IllegalStateException("can not be instanced.");
    }

    @Nullable
    public static AttributeSet createAttributeSet(byte[] data) {
        if (data == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 31) {
            try {
                AttributeSet set = UltimateInflaterXmlBlockHelper.createAttributeSetDirectly(data);
                Log.i((String)TAG, (String)"create AttributeSet directly successfully.");
                return set;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("create AttributeSet directly unsuccessfully : " + e + "."));
            }
        }
        try {
            AttributeSet set = UltimateInflaterXmlBlockHelper.createAttributeSetByReflection(data);
            Log.i((String)TAG, (String)"create AttributeSet by reflection successfully.");
            return set;
        }
        catch (Throwable re) {
            Log.e((String)TAG, (String)("create AttributeSet by reflection unsuccessfully : " + re + "."));
            return null;
        }
    }

    private static AttributeSet createAttributeSetDirectly(byte[] data) throws Throwable {
        throw new IllegalStateException("Please apply ultimate-inflater-plugin");
    }

    private static AttributeSet createAttributeSetByReflection(byte[] data) throws Throwable {
        Constructor<?> constructor = UltimateInflaterXmlBlockHelper.getXmlBlockConstructor();
        constructor.setAccessible(true);
        Object xmlBlock = constructor.newInstance(new Object[]{data});
        Method methodNewParser = UltimateInflaterXmlBlockHelper.getNewParserMethod();
        methodNewParser.setAccessible(true);
        return (AttributeSet)methodNewParser.invoke(xmlBlock, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
    private static Constructor<?> getXmlBlockConstructor() throws Throwable {
        Constructor<?> constructor = xmlBlockConstructor;
        if (constructor != null) return constructor;
        Class<UltimateInflaterXmlBlockHelper> clazz = UltimateInflaterXmlBlockHelper.class;
        synchronized (UltimateInflaterXmlBlockHelper.class) {
            constructor = xmlBlockConstructor;
            if (constructor != null) return constructor;
            Class<?> xmlBlockClass = Class.forName(XML_BLOCK_CLASS);
            xmlBlockConstructor = constructor = xmlBlockClass.getConstructor(byte[].class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return constructor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
    private static Method getNewParserMethod() throws Throwable {
        Method method = newParserMethod;
        if (method != null) return method;
        Class<UltimateInflaterXmlBlockHelper> clazz = UltimateInflaterXmlBlockHelper.class;
        synchronized (UltimateInflaterXmlBlockHelper.class) {
            method = newParserMethod;
            if (method != null) return method;
            newParserMethod = method = Class.forName(XML_BLOCK_CLASS).getDeclaredMethod("newParser", new Class[0]);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return method;
        }
    }
}

