/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.view.View;
import java.lang.reflect.Field;

public final class UltimateInflaterViewHelper
extends View {
    private static final String TAG = "ViewHelper";
    private static volatile Field viewContextField = null;

    private UltimateInflaterViewHelper(Context context) {
        super(context);
    }

    public static void onFinishInflate(View view) {
        if (view != null) {
            view.onFinishInflate();
        }
    }

    public static boolean updateContext(View view, Context context) {
        if (view != null && context != null) {
            try {
                UltimateInflaterViewHelper.updateContextDirectly(view, context);
                Log.i((String)TAG, (String)"update context directly successfully.");
                return true;
            }
            catch (Throwable e) {
                Log.i((String)TAG, (String)("update context directly unsuccessfully : " + e + "."));
                try {
                    UltimateInflaterViewHelper.updateContextByReflection(view, context);
                    Log.i((String)TAG, (String)"update context by reflection successfully.");
                    return true;
                }
                catch (Throwable e2) {
                    Log.e((String)TAG, (String)("update context by reflection unsuccessfully : " + e2 + "."));
                }
            }
        }
        return false;
    }

    private static void updateContextDirectly(View view, Context context) throws Throwable {
        throw new IllegalStateException("Please apply ultimate-inflater-plugin");
    }

    @SuppressLint(value={"DiscouragedPrivateApi"})
    private static void updateContextByReflection(View view, Context context) throws Throwable {
        Field mContextField = UltimateInflaterViewHelper.getViewContextField();
        mContextField.setAccessible(true);
        mContextField.set(view, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Field getViewContextField() throws Throwable {
        Field contextFiled = viewContextField;
        if (contextFiled != null) return contextFiled;
        Class<UltimateInflaterViewHelper> clazz = UltimateInflaterViewHelper.class;
        synchronized (UltimateInflaterViewHelper.class) {
            contextFiled = viewContextField;
            if (contextFiled != null) return contextFiled;
            viewContextField = contextFiled = View.class.getDeclaredField("mContext");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return contextFiled;
        }
    }
}

