/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ultimate.inflater.internal.cache;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.bytedance.ultimate.inflater.UltimateInflater;
import com.bytedance.ultimate.inflater.internal.cache.CacheItem;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/bytedance/ultimate/inflater/internal/cache/CacheHandler;", "Landroid/os/Handler;", "callback", "Lcom/bytedance/ultimate/inflater/internal/cache/CacheHandler$OnCacheExpiredCallback;", "(Lcom/bytedance/ultimate/inflater/internal/cache/CacheHandler$OnCacheExpiredCallback;)V", "creatingCacheKeepAliveTime", "", "getCreatingCacheKeepAliveTime", "()J", "readyCacheKeepAliveTime", "getReadyCacheKeepAliveTime", "expireCacheDelay", "", "what", "", "cacheItem", "Lcom/bytedance/ultimate/inflater/internal/cache/CacheItem;", "delayMills", "expireCreatingCacheDelay", "expireReadyCacheDelay", "handleMessage", "msg", "Landroid/os/Message;", "withdrawExpiringCreatingCache", "Companion", "OnCacheExpiredCallback", "ultimate-inflater_release"})
public final class CacheHandler
extends Handler {
    private final OnCacheExpiredCallback callback;
    private static final int WHAT_CREATING_CACHE = 1;
    private static final int WHAT_READY_CACHE = 2;
    public static final Companion Companion = new Companion(null);

    private final long getCreatingCacheKeepAliveTime() {
        return UltimateInflater.INSTANCE.getCreatingCacheKeepAliveTime$ultimate_inflater_release();
    }

    private final long getReadyCacheKeepAliveTime() {
        return UltimateInflater.INSTANCE.getReadyCacheKeepAliveTime$ultimate_inflater_release();
    }

    public final void expireCreatingCacheDelay(@NotNull CacheItem cacheItem) {
        Intrinsics.checkParameterIsNotNull((Object)cacheItem, (String)"cacheItem");
        this.expireCacheDelay(1, cacheItem, this.getCreatingCacheKeepAliveTime());
    }

    public final void withdrawExpiringCreatingCache(@NotNull CacheItem cacheItem) {
        Intrinsics.checkParameterIsNotNull((Object)cacheItem, (String)"cacheItem");
        this.removeMessages(1, cacheItem.getId());
    }

    public final void expireReadyCacheDelay(@NotNull CacheItem cacheItem) {
        Intrinsics.checkParameterIsNotNull((Object)cacheItem, (String)"cacheItem");
        this.expireCacheDelay(2, cacheItem, this.getReadyCacheKeepAliveTime());
    }

    private final void expireCacheDelay(int what, CacheItem cacheItem, long delayMills) {
        Message message = Message.obtain();
        message.what = what;
        message.arg1 = cacheItem.getLayoutId();
        message.obj = cacheItem.getId();
        this.sendMessageDelayed(message, delayMills);
    }

    public void handleMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        super.handleMessage(msg);
        Object object = msg.obj;
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return;
        }
        String cacheId = string;
        int layoutId = msg.arg1;
        switch (msg.what) {
            case 1: {
                this.callback.onCreatingCacheExpired(layoutId, cacheId);
                break;
            }
            case 2: {
                this.callback.onReadyCacheExpired(layoutId, cacheId);
                break;
            }
        }
    }

    public CacheHandler(@NotNull OnCacheExpiredCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        super(Looper.getMainLooper());
        this.callback = callback;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lcom/bytedance/ultimate/inflater/internal/cache/CacheHandler$OnCacheExpiredCallback;", "", "onCreatingCacheExpired", "", "layoutId", "", "cacheId", "", "onReadyCacheExpired", "ultimate-inflater_release"})
    public static interface OnCacheExpiredCallback {
        public void onCreatingCacheExpired(int var1, @NotNull String var2);

        public void onReadyCacheExpired(int var1, @NotNull String var2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/bytedance/ultimate/inflater/internal/cache/CacheHandler$Companion;", "", "()V", "WHAT_CREATING_CACHE", "", "WHAT_READY_CACHE", "ultimate-inflater_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

