/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ultimate.inflater.internal.counter;

import com.bytedance.ultimate.inflater.counter.ViewSizeCounterConsumer;
import com.bytedance.ultimate.inflater.counter.ViewSizeCounterProducer;
import com.bytedance.ultimate.inflater.exception.LayoutCreatorInvalidationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000eJ\b\u0010\u0018\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/bytedance/ultimate/inflater/internal/counter/ViewSizeCounter;", "Lcom/bytedance/ultimate/inflater/counter/ViewSizeCounterProducer;", "Lcom/bytedance/ultimate/inflater/counter/ViewSizeCounterConsumer;", "()V", "createdViewCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "invalidateThrowable", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "toFinished", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "totalViewCount", "", "checkInvalidation", "", "increment", "invalidate", "throwable", "isFinished", "", "updateTotalCount", "count", "waitToFinish", "ultimate-inflater_release"})
public final class ViewSizeCounter
implements ViewSizeCounterProducer,
ViewSizeCounterConsumer {
    private volatile int totalViewCount = -1;
    private final AtomicInteger createdViewCount = new AtomicInteger(0);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition toFinished = this.lock.newCondition();
    private volatile Throwable invalidateThrowable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment() {
        if (this.totalViewCount <= 0) {
            throw (Throwable)new IllegalStateException("Total view count <= 0.");
        }
        int createdCount = this.createdViewCount.incrementAndGet();
        if (createdCount > this.totalViewCount) {
            throw (Throwable)new IllegalStateException("created view count " + createdCount + " is bigger than total view count " + this.totalViewCount + '.');
        }
        this.checkInvalidation();
        if (createdCount == this.totalViewCount) {
            Lock lock = this.lock;
            boolean bl = false;
            lock.lock();
            try {
                boolean bl2 = false;
                this.toFinished.signalAll();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.invalidateThrowable = throwable;
            this.toFinished.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitToFinish() {
        if (this.totalViewCount < 0) {
            throw (Throwable)new IllegalStateException("view count <= 0, please call #ViewSizeCountersetViewCount first.");
        }
        this.checkInvalidation();
        int count = this.createdViewCount.get();
        if (count == this.totalViewCount) {
            return;
        }
        if (count > this.totalViewCount) {
            throw (Throwable)new IllegalStateException("created view count " + count + " is bigger than total view count " + this.totalViewCount + '.');
        }
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.checkInvalidation();
            if (this.createdViewCount.get() != this.totalViewCount) {
                this.toFinished.await();
            }
            this.checkInvalidation();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isFinished() {
        this.checkInvalidation();
        return this.totalViewCount == this.createdViewCount.get();
    }

    public final void updateTotalCount(int count) {
        if (count < 1) {
            throw (Throwable)new IllegalArgumentException("count must be bigger than 0");
        }
        if (this.totalViewCount != -1) {
            throw (Throwable)new IllegalStateException("cannot call ViewSizeCounter#updateTotalCount twice.");
        }
        this.totalViewCount = count;
    }

    private final void checkInvalidation() {
        Throwable throwable = this.invalidateThrowable;
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable3 = throwable2;
            boolean bl3 = false;
            throw (Throwable)new LayoutCreatorInvalidationException(throwable3);
        }
    }
}

