/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ultimate.inflater.internal.spi;

import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LayoutNameToIdRegistry {
    private static final ConcurrentHashMap<String, Integer> layoutNameToId = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, String> layoutIdToName = new ConcurrentHashMap();

    private LayoutNameToIdRegistry() {
        throw new IllegalStateException("LayoutNameToIdRegistry cannot be instantiated!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static Integer get(@NotNull String layoutName) {
        if (layoutName == null) {
            return null;
        }
        Integer layoutId = layoutNameToId.get(layoutName);
        if (layoutId != null) {
            return layoutId;
        }
        ConcurrentHashMap<String, Integer> concurrentHashMap = layoutNameToId;
        synchronized (concurrentHashMap) {
            layoutId = layoutNameToId.get(layoutName);
            if (layoutId != null) {
                return layoutId;
            }
            layoutId = LayoutNameToIdRegistry.getLayoutIdByName(layoutName);
            if (layoutId != -1) {
                layoutNameToId.putIfAbsent(layoutName, layoutId);
                layoutIdToName.putIfAbsent(layoutId, layoutName);
            }
        }
        return layoutId;
    }

    static void putIfAbsent(int layoutId, String layoutName) {
        layoutIdToName.putIfAbsent(layoutId, layoutName);
        layoutNameToId.putIfAbsent(layoutName, layoutId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static String get(int layoutId) {
        String layoutName = layoutIdToName.get(layoutId);
        if (layoutName != null) {
            return layoutName;
        }
        ConcurrentHashMap<Integer, String> concurrentHashMap = layoutIdToName;
        synchronized (concurrentHashMap) {
            layoutName = layoutIdToName.get(layoutId);
            if (layoutName != null) {
                return layoutName;
            }
            layoutName = LayoutNameToIdRegistry.getLayoutNameById(layoutId);
            if (layoutName != null) {
                layoutIdToName.putIfAbsent(layoutId, layoutName);
                layoutNameToId.putIfAbsent(layoutName, layoutId);
            }
            return layoutName;
        }
    }

    private static int getLayoutIdByName(String layoutName) {
        return -1;
    }

    private static String getLayoutNameById(int layoutId) {
        return null;
    }
}

