/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf;

import com.bytedance.bmf.API;
import com.bytedance.bmf.OpaqueDataKey;
import com.bytedance.bmf.Rational;
import com.bytedance.hmp.EnumUtil;
import com.bytedance.hmp.Ptr;
import com.bytedance.hmp.ScalarType;
import com.bytedance.hmp.Tensor;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class AudioFrame
extends Ptr {
    public static AudioFrame wrap(long p, boolean own) {
        return new AudioFrame(p, own);
    }

    AudioFrame(long p, boolean own) {
        this.ptr = p;
        this.own = own;
    }

    public AudioFrame(Tensor[] data, int size, int layout, boolean planer) {
        int len = data.length;
        long[] dataPtr = new long[len];
        for (int i = 0; i < len; ++i) {
            dataPtr[i] = data[i].getPtr();
        }
        this.ptr = API.bmf_af_make_from_data(dataPtr, size, layout, planer);
        this.own = true;
    }

    public AudioFrame(int samples, int layout, boolean planer, ScalarType dtype) {
        this.ptr = API.bmf_af_make(samples, layout, planer, dtype.getValue());
        this.own = true;
    }

    public void free() {
        if (this.own) {
            API.bmf_af_free(this.ptr);
        }
    }

    public boolean defined() {
        return API.bmf_af_defined(this.ptr);
    }

    public ScalarType dtype() {
        int dtype = API.bmf_af_dtype(this.ptr);
        ScalarType scalarType = (ScalarType)((Object)EnumUtil.fromValue(ScalarType.class, dtype));
        return scalarType;
    }

    public boolean planer() {
        return API.bmf_af_planer(this.ptr);
    }

    public int nsamples() {
        return API.bmf_af_nsamples(this.ptr);
    }

    public int nchannels() {
        return API.bmf_af_nchannels(this.ptr);
    }

    public void setSampleRate(float sampleRate) {
        API.bmf_af_set_sample_rate(this.ptr, sampleRate);
    }

    public float sampleRate() {
        return API.bmf_af_sample_rate(this.ptr);
    }

    public Tensor[] planes() {
        long[] tensorPtr = API.bmf_af_planes(this.ptr);
        int len = tensorPtr.length;
        Tensor[] planes = new Tensor[len];
        for (int i = 0; i < len; ++i) {
            planes[i] = Tensor.wrap(tensorPtr[i], true);
        }
        return planes;
    }

    public int nplanes() {
        return API.bmf_af_nplanes(this.ptr);
    }

    public Tensor plane(int i) {
        long planePtr = API.bmf_af_plane(this.ptr, i);
        return Tensor.wrap(planePtr, true);
    }

    public void copyProps(AudioFrame from) {
        API.bmf_af_copy_props(this.ptr, from.ptr);
    }

    public void privateMerge(AudioFrame from) {
        API.bmf_af_private_merge(this.ptr, from.ptr);
    }

    public Object privateGet(OpaqueDataKey opaqueDataKey) throws IllegalArgumentException {
        switch (opaqueDataKey) {
            case kJsonParam: {
                long jsonParamPtr = API.bmf_af_private_get_json_param(this.ptr);
                String jsonParamStr = API.bmf_json_param_dump(jsonParamPtr);
                Gson gson = new Gson();
                return gson.fromJson(jsonParamStr, JsonObject.class);
            }
        }
        throw new IllegalArgumentException("Unknown opaque data key in PrivateGet");
    }

    public void privateAttach(OpaqueDataKey opaqueDataKey, Object option) throws IllegalArgumentException {
        switch (opaqueDataKey) {
            case kJsonParam: {
                JsonObject json = (JsonObject)option;
                String opt = json.toString();
                long optPtr = API.bmf_json_param_parse(opt);
                API.bmf_af_private_attach_json_param(this.ptr, optPtr);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown opaque data key in PrivateAttach");
            }
        }
    }

    public void setPts(long pts) {
        API.bmf_af_set_pts(this.ptr, pts);
    }

    public long pts() {
        return API.bmf_af_pts(this.ptr);
    }

    public void setTimeBase(Rational rational) {
        API.bmf_af_set_time_base(this.ptr, rational.num, rational.den);
    }

    public Rational timeBase() {
        int[] tb = API.bmf_af_time_base(this.ptr);
        return new Rational(tb[0], tb[1]);
    }
}

