/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf;

import com.bytedance.bmf.API;
import com.bytedance.hmp.Ptr;

public class JsonParam
extends Ptr {
    public static JsonParam wrap(long p, boolean own) {
        JsonParam jsonParam = new JsonParam(p, own);
        return jsonParam;
    }

    JsonParam(long p, boolean own) {
        this.ptr = p;
        this.own = own;
    }

    public JsonParam() {
        this.ptr = API.bmf_json_make();
        this.own = true;
    }

    public void free() {
        if (this.own) {
            API.bmf_json_free(this.ptr);
        }
    }

    public boolean hasKey(String key) {
        return API.bmf_json_has_key(this.ptr, key);
    }

    public boolean erase(String key) {
        return API.bmf_json_erase(this.ptr, key);
    }

    public String dump() {
        return API.bmf_json_dump(this.ptr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(String key, Object value) throws Exception {
        if (value instanceof Integer) {
            API.bmf_json_set_int(this.ptr, key, (Integer)value);
            return;
        } else if (value instanceof Long) {
            API.bmf_json_set_long(this.ptr, key, (Long)value);
            return;
        } else if (value instanceof Float) {
            API.bmf_json_set_float(this.ptr, key, ((Float)value).floatValue());
            return;
        } else if (value instanceof Double) {
            API.bmf_json_set_double(this.ptr, key, (Double)value);
            return;
        } else if (value instanceof String) {
            API.bmf_json_set_string(this.ptr, key, (String)value);
            return;
        } else {
            if (!value.getClass().isArray()) throw new IllegalArgumentException("Unknown type for Jsonparam set()");
            if (value instanceof int[]) {
                API.bmf_json_set_int_list(this.ptr, key, (int[])value);
                return;
            } else if (value instanceof float[]) {
                API.bmf_json_set_float_list(this.ptr, key, (float[])value);
                return;
            } else if (value instanceof double[]) {
                API.bmf_json_set_double_list(this.ptr, key, (double[])value);
                return;
            } else {
                if (!(value instanceof String[])) throw new IllegalArgumentException("Unknown array type for Jsonparam set()");
                API.bmf_json_set_string_list(this.ptr, key, (String[])value);
            }
        }
    }

    public int getInt(String key) {
        return API.bmf_json_get_int(this.ptr, key);
    }

    public long getLong(String key) {
        return API.bmf_json_get_long(this.ptr, key);
    }

    public float getFloat(String key) {
        return API.bmf_json_get_float(this.ptr, key);
    }

    public double getDouble(String key) {
        return API.bmf_json_get_double(this.ptr, key);
    }

    public String getString(String key) {
        return API.bmf_json_get_string(this.ptr, key);
    }

    public int[] getIntList(String key) {
        return API.bmf_json_get_int_list(this.ptr, key);
    }

    public float[] getFloatList(String key) {
        return API.bmf_json_get_float_list(this.ptr, key);
    }

    public double[] getDoubleList(String key) {
        return API.bmf_json_get_double_list(this.ptr, key);
    }

    public String[] getStringList(String key) {
        return API.bmf_json_get_string_list(this.ptr, key);
    }
}

