/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf;

import com.bytedance.bmf.API;
import com.bytedance.bmf.ModuleInfo;
import com.bytedance.bmf.Packet;
import com.bytedance.hmp.Ptr;
import com.google.gson.Gson;

public class ModuleFunctor
extends Ptr {
    Class[] inputTypes;
    Class[] outputTypes;
    boolean cleanup = true;

    public static ModuleFunctor wrap(long p, boolean own) {
        return new ModuleFunctor(p, own);
    }

    ModuleFunctor(long p, boolean own) {
        this.ptr = p;
        this.own = own;
    }

    public ModuleFunctor(ModuleInfo moduleInfo, Object option, Class[] inputTypes, Class[] outputTypes) {
        Gson gson = new Gson();
        String optStr = gson.toJson(option);
        this.ptr = API.bmf_module_functor_make(moduleInfo.name, moduleInfo.type, moduleInfo.path, moduleInfo.entry, optStr, inputTypes.length, outputTypes.length, -1);
        this.own = true;
        this.inputTypes = inputTypes;
        this.outputTypes = outputTypes;
    }

    public ModuleFunctor(ModuleInfo moduleInfo, Object option, Class[] inputTypes, Class[] outputTypes, boolean cleanup) {
        this(moduleInfo, option, inputTypes, outputTypes);
        this.cleanup = cleanup;
    }

    public void free() {
        if (this.own) {
            API.bmf_module_functor_free(this.ptr);
        }
    }

    Packet[] _inputs(Object[] inputs) throws Exception {
        if (inputs == null) {
            return new Packet[this.inputTypes.length];
        }
        if (inputs.length != this.inputTypes.length) {
            throw new IllegalArgumentException(String.format("Expect %d inputs, got %d", this.inputTypes.length, inputs.length));
        }
        Packet[] ipkts = new Packet[this.inputTypes.length];
        try {
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] != null && this.inputTypes[i] != null && !this.inputTypes[i].isInstance(inputs[i])) {
                    throw new IllegalArgumentException(String.format("Expect input type %s at %d, got %s", this.inputTypes[i].getName(), i, inputs[i].getClass().getName()));
                }
                ipkts[i] = new Packet(inputs[i]);
            }
        }
        catch (Exception e) {
            for (int i = 0; i < ipkts.length; ++i) {
                if (ipkts[i] == null) continue;
                ipkts[i].free();
            }
            throw e;
        }
        return ipkts;
    }

    Object _output(Packet pkt, int port) throws Exception {
        if (pkt.getPtr() == 0L) {
            return null;
        }
        if (this.outputTypes[port] == null) {
            return pkt;
        }
        return pkt.get(this.outputTypes[port]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] call(Object ... inputs) throws Exception {
        Packet[] ipkts = this._inputs(inputs);
        Packet[] opkts = new Packet[this.outputTypes.length];
        try {
            int i;
            long[] ipktPtrs = new long[ipkts.length];
            for (int i2 = 0; i2 < ipkts.length; ++i2) {
                ipktPtrs[i2] = ipkts[i2].getPtr();
            }
            long[] opktPtrs = API.bmf_module_functor_call(this.ptr, ipktPtrs);
            if (opktPtrs == null) {
                throw new IllegalStateException("output pkt (opktPtrs) is null");
            }
            if (opktPtrs.length != this.outputTypes.length) {
                for (int i3 = 0; i3 < opktPtrs.length; ++i3) {
                    API.bmf_packet_free(opktPtrs[i3]);
                }
                throw new IllegalStateException(String.format("Expect %d outputs, got %d", this.outputTypes.length, opktPtrs.length));
            }
            for (i = 0; i < opktPtrs.length; ++i) {
                opkts[i] = Packet.wrap(opktPtrs[i], true);
            }
            for (i = 0; i < opkts.length; ++i) {
                if (opkts[i].getPtr() == 0L || this.outputTypes[i] == null || opkts[i].is(this.outputTypes[i])) continue;
                throw new IllegalStateException(String.format("Invalid output packet type at port %d, expect %s", i, this.outputTypes[i].getName()));
            }
            Object[] robjs = new Object[opktPtrs.length];
            for (int i4 = 0; i4 < opktPtrs.length; ++i4) {
                robjs[i4] = this._output(opkts[i4], i4);
            }
            Object[] objectArray = robjs;
            return objectArray;
        }
        finally {
            int i;
            for (i = 0; i < ipkts.length; ++i) {
                ipkts[i].free();
            }
            for (i = 0; i < opkts.length; ++i) {
                if (opkts[i] == null) continue;
                opkts[i].free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object ... inputs) throws Exception {
        Packet[] ipkts = this._inputs(inputs);
        try {
            long[] ipktPtrs = new long[ipkts.length];
            for (int i = 0; i < ipkts.length; ++i) {
                ipktPtrs[i] = ipkts[i].getPtr();
            }
            API.bmf_module_functor_execute(this.ptr, ipktPtrs, this.cleanup);
        }
        finally {
            for (int i = 0; i < ipkts.length; ++i) {
                ipkts[i].free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] fetch(int port) throws Exception {
        int i;
        long[] opktPtrs = API.bmf_module_functor_fetch(this.ptr, port);
        Packet[] opkts = new Packet[opktPtrs.length];
        for (i = 0; i < opktPtrs.length; ++i) {
            opkts[i] = Packet.wrap(opktPtrs[i], true);
        }
        try {
            for (i = 0; i < opkts.length; ++i) {
                if (opkts[i].getPtr() == 0L || this.outputTypes[port] == null || opkts[i].is(this.outputTypes[port])) continue;
                throw new IllegalStateException(String.format("Invalid output packet type at %d from port %d, expect %s", i, port, this.outputTypes[port].getName()));
            }
            Object[] robjs = new Object[opktPtrs.length];
            for (int i2 = 0; i2 < opktPtrs.length; ++i2) {
                robjs[i2] = this._output(opkts[i2], port);
            }
            Object[] objectArray = robjs;
            return objectArray;
        }
        finally {
            for (int i3 = 0; i3 < opkts.length; ++i3) {
                opkts[i3].free();
            }
        }
    }
}

