/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf;

import com.bytedance.bmf.API;
import com.bytedance.bmf.JsonParam;
import com.bytedance.bmf.VideoFrame;
import com.bytedance.hmp.Ptr;
import com.google.gson.Gson;

public class Packet
extends Ptr {
    public static Packet wrap(long p, boolean own) {
        Packet packet = new Packet(p, own);
        return packet;
    }

    Packet(long p, boolean own) {
        this.ptr = p;
        this.own = own;
    }

    static Packet generateEosPacket() {
        long ptr = API.bmf_packet_generate_eos_packet();
        return Packet.wrap(ptr, true);
    }

    static Packet generateEofPacket() {
        long ptr = API.bmf_packet_generate_eof_packet();
        return Packet.wrap(ptr, true);
    }

    public Packet(Object data) {
        if (data == null) {
            this.ptr = 0L;
            this.own = false;
        } else {
            Class<?> clz = data.getClass();
            if (clz == VideoFrame.class) {
                VideoFrame vf = (VideoFrame)data;
                this.ptr = API.bmf_packet_from_videoframe(vf.getPtr());
                this.own = true;
            } else if (clz == Packet.class) {
                Packet pkt = (Packet)data;
                this.ptr = pkt.getPtr();
                this.own = false;
            } else if (clz == JsonParam.class) {
                JsonParam json = (JsonParam)data;
                this.ptr = API.bmf_packet_from_json_param(json.getPtr());
                this.own = true;
            } else {
                Gson gson = new Gson();
                String str = gson.toJson(data);
                this.ptr = API.bmf_packet_from_json_str(str);
                this.own = true;
            }
        }
    }

    public void free() {
        if (this.own) {
            API.bmf_packet_free(this.ptr);
        }
    }

    public long timestamp() {
        return API.bmf_packet_timestamp(this.ptr);
    }

    public void setTimestamp(long ts) {
        API.bmf_packet_set_timestamp(this.ptr, ts);
    }

    public boolean defined() {
        return API.bmf_packet_defined(this.ptr) != 0;
    }

    public boolean is(Class clz) {
        if (clz == VideoFrame.class) {
            return API.bmf_packet_is_videoframe(this.ptr);
        }
        return API.bmf_packet_is_json_param(this.ptr);
    }

    public Object get(Class clz) throws ClassCastException {
        if (clz == VideoFrame.class) {
            long vfPtr = API.bmf_packet_get_videoframe(this.ptr);
            return VideoFrame.wrap(vfPtr, true);
        }
        if (clz == JsonParam.class) {
            long jsonPtr = API.bmf_packet_get_json_param(this.ptr);
            return JsonParam.wrap(jsonPtr, true);
        }
        if (API.bmf_packet_is_json_param(this.ptr)) {
            String str = API.bmf_packet_to_json_str(this.ptr);
            Gson gson = new Gson();
            return gson.fromJson(str, clz);
        }
        throw new ClassCastException(clz.getName());
    }
}

