/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf;

import com.bytedance.bmf.API;
import com.bytedance.bmf.OpaqueDataKey;
import com.bytedance.bmf.Rational;
import com.bytedance.hmp.ChannelFormat;
import com.bytedance.hmp.DeviceType;
import com.bytedance.hmp.EnumUtil;
import com.bytedance.hmp.Frame;
import com.bytedance.hmp.Image;
import com.bytedance.hmp.PixelInfo;
import com.bytedance.hmp.Ptr;
import com.bytedance.hmp.ScalarType;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class VideoFrame
extends Ptr {
    public static VideoFrame wrap(long p, boolean own) {
        return new VideoFrame(p, own);
    }

    VideoFrame(long p, boolean own) {
        this.ptr = p;
        this.own = own;
    }

    public VideoFrame(Image image) {
        this.ptr = API.bmf_vf_from_image(image.getPtr());
        this.own = true;
    }

    public VideoFrame(Frame frame) {
        this.ptr = API.bmf_vf_from_frame(frame.getPtr());
        this.own = true;
    }

    public VideoFrame(int width, int height, int channels, ChannelFormat cformat, ScalarType dtype, String device, boolean pinned_memory) {
        this.ptr = API.bmf_vf_make_image(width, height, channels, cformat.getValue(), dtype.getValue(), device, pinned_memory);
        this.own = true;
    }

    public VideoFrame(int width, int height, PixelInfo pixelInfo, String device) {
        this.ptr = API.bmf_vf_make_frame(width, height, pixelInfo.getPtr(), device);
        this.own = true;
    }

    public void free() {
        if (this.own) {
            API.bmf_vf_free(this.ptr);
        }
    }

    public boolean defined() {
        return API.bmf_vf_defined(this.ptr);
    }

    public int width() {
        int width = API.bmf_vf_width(this.ptr);
        return width;
    }

    public int height() {
        int height = API.bmf_vf_height(this.ptr);
        return height;
    }

    public ScalarType dtype() {
        int dtype = API.bmf_vf_dtype(this.ptr);
        ScalarType scalarType = (ScalarType)((Object)EnumUtil.fromValue(ScalarType.class, dtype));
        return scalarType;
    }

    public boolean isImage() {
        return API.bmf_vf_is_image(this.ptr);
    }

    public Image image() {
        long imgPtr = API.bmf_vf_image(this.ptr);
        return Image.wrap(imgPtr, false);
    }

    public Frame frame() {
        long frmPtr = API.bmf_vf_frame(this.ptr);
        return Frame.wrap(frmPtr, false);
    }

    public VideoFrame toImage(ChannelFormat channelFormat, boolean contiguous) {
        long newPtr = API.bmf_vf_to_image(this.ptr, channelFormat.getValue(), contiguous);
        return VideoFrame.wrap(newPtr, true);
    }

    public VideoFrame toFrame(PixelInfo pixelInfo) {
        long newPtr = API.bmf_vf_to_frame(this.ptr, pixelInfo.getPtr());
        return VideoFrame.wrap(newPtr, true);
    }

    public DeviceType deviceType() {
        int type = API.bmf_vf_device_type(this.ptr);
        DeviceType deviceType = DeviceType.kCPU;
        if (type == 0) {
            deviceType = DeviceType.kCPU;
        } else if (type == 1) {
            deviceType = DeviceType.kCUDA;
        }
        return deviceType;
    }

    public int deviceIndex() {
        return API.bmf_vf_device_index(this.ptr);
    }

    public void copyFrom(VideoFrame from) {
        API.bmf_vf_copy_from(this.ptr, from.getPtr());
    }

    public VideoFrame to(String device, boolean non_blocking) {
        long newPtr = API.bmf_vf_to_device(this.ptr, device, non_blocking);
        return VideoFrame.wrap(newPtr, true);
    }

    public VideoFrame to(ScalarType scalarType) {
        long newPtr = API.bmf_vf_to_dtype(this.ptr, scalarType.getValue());
        return VideoFrame.wrap(newPtr, true);
    }

    public void copyProps(VideoFrame from) {
        API.bmf_vf_copy_props(this.ptr, from.ptr);
    }

    public void privateMerge(VideoFrame from) {
        API.bmf_vf_private_merge(this.ptr, from.ptr);
    }

    public Object privateGet(OpaqueDataKey opaqueDataKey) throws IllegalArgumentException {
        switch (opaqueDataKey) {
            case kJsonParam: {
                long jsonParamPtr = API.bmf_vf_private_get_json_param(this.ptr);
                String jsonParamStr = API.bmf_json_param_dump(jsonParamPtr);
                Gson gson = new Gson();
                return gson.fromJson(jsonParamStr, JsonObject.class);
            }
        }
        throw new IllegalArgumentException("Unknown opaque data key in PrivateGet");
    }

    public void privateAttach(OpaqueDataKey opaqueDataKey, Object option) throws IllegalArgumentException {
        switch (opaqueDataKey) {
            case kJsonParam: {
                JsonObject json = (JsonObject)option;
                String opt = json.toString();
                long optPtr = API.bmf_json_param_parse(opt);
                API.bmf_vf_private_attach_json_param(this.ptr, optPtr);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown opaque data key in PrivateAttach");
            }
        }
    }

    public void setPts(long pts) {
        API.bmf_vf_set_pts(this.ptr, pts);
    }

    public long pts() {
        return API.bmf_vf_pts(this.ptr);
    }

    public void setTimeBase(Rational rational) {
        API.bmf_vf_set_time_base(this.ptr, rational.num, rational.den);
    }

    public Rational timeBase() {
        int[] tb = API.bmf_vf_time_base(this.ptr);
        return new Rational(tb[0], tb[1]);
    }

    public boolean ready() {
        return API.bmf_vf_ready(this.ptr);
    }

    public void record(boolean use_current) {
        API.bmf_vf_record(this.ptr, use_current);
    }

    public void synchronize() {
        API.bmf_vf_synchronize(this.ptr);
    }
}

