/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf_mods;

import com.bytedance.bmf.ModuleFunctor;
import com.bytedance.bmf.ModuleInfo;
import com.bytedance.bmf_mods.Logging;
import com.bytedance.bmf_mods_api.ColorShiftAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ss.android.ugc.aweme.framework.services.annotation.ServiceImpl;

@ServiceImpl(service={ColorShiftAPI.class}, singleton=true)
public class ColorShift
implements ColorShiftAPI {
    private JsonObject srOption = new JsonObject();
    private ModuleInfo srModuleInfo = null;
    private ModuleFunctor srFunc = null;
    private static volatile boolean sIsSoInitialized = false;

    public ColorShift() {
        Logging.d("New ColorShift");
    }

    @Override
    public boolean Init(boolean enableProfile, float bright, float saturation, float[] shift_positive, float[] shift_negative, int input_texture_type) {
        if (!sIsSoInitialized) {
            return false;
        }
        this.srOption.addProperty("enable_profile", Boolean.valueOf(enableProfile));
        this.srOption.addProperty("bright", (Number)Float.valueOf(bright));
        this.srOption.addProperty("saturation", (Number)Float.valueOf(saturation));
        this.srOption.addProperty("input_texture_type", (Number)input_texture_type);
        JsonArray jsonArray = new JsonArray();
        for (float n : shift_positive) {
            jsonArray.add((Number)Float.valueOf(n));
        }
        this.srOption.add("shift_positive", (JsonElement)jsonArray);
        JsonArray json_shift_negative = new JsonArray();
        for (float n : shift_negative) {
            json_shift_negative.add((Number)Float.valueOf(n));
        }
        this.srOption.add("shift_negative", (JsonElement)json_shift_negative);
        this.srModuleInfo = new ModuleInfo("ColorShiftModule", "c++", "libbmf_hydra.so", "");
        Class[] itypes = new Class[]{JsonObject.class};
        Class[] otypes = new Class[]{JsonObject.class};
        try {
            Logging.d("ColorShift: load ColorShift Module");
            this.srFunc = new ModuleFunctor(this.srModuleInfo, this.srOption, itypes, otypes);
            Logging.d("ColorShift: load ColorShift Module success");
        }
        catch (Exception e) {
            Logging.d("ColorShift: load ColorShift Module failed," + e.toString());
            return false;
        }
        return true;
    }

    @Override
    public int Process(int textureId, int otextureId, int width, int height) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.srFunc == null) {
            return -1;
        }
        JsonObject input = new JsonObject();
        input.addProperty("input_texture", (Number)textureId);
        input.addProperty("output_texture", (Number)otextureId);
        input.addProperty("width", (Number)width);
        input.addProperty("height", (Number)height);
        JsonObject output = null;
        try {
            Object[] objs = this.srFunc.call(input);
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("ColorShift: call ColorShift module failed," + e.toString());
            e.printStackTrace();
            return -1;
        }
        return otextureId;
    }

    @Override
    public int oesProcess(int textureId, int otextureId, int width, int height, float[] matrix) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.srFunc == null) {
            return -1;
        }
        JsonObject input = new JsonObject();
        input.addProperty("input_texture", (Number)textureId);
        input.addProperty("output_texture", (Number)otextureId);
        input.addProperty("width", (Number)width);
        input.addProperty("height", (Number)height);
        JsonArray jsonArray = new JsonArray();
        for (float n : matrix) {
            jsonArray.add((Number)Float.valueOf(n));
        }
        input.add("matrix", (JsonElement)jsonArray);
        JsonObject output = null;
        try {
            Object[] objs = this.srFunc.call(input);
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("ColorShift: call ColorShift module failed," + e.toString());
            e.printStackTrace();
            return -1;
        }
        return otextureId;
    }

    @Override
    public void Free() {
        if (this.srFunc != null) {
            this.srFunc.free();
        }
    }

    static {
        try {
            System.loadLibrary("hmp");
            System.loadLibrary("bmf_module_sdk");
            System.loadLibrary("bmf_hydra");
            sIsSoInitialized = true;
            Logging.d("color shift is initialized");
        }
        catch (Throwable t) {
            Logging.d("color shift initialize occurs error, the msg = " + t.getMessage());
            sIsSoInitialized = false;
        }
    }
}

