/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf_mods;

import android.opengl.GLES20;
import com.bytedance.bmf_mods.Logging;

public class GLUtils {
    public static int createFbo() {
        int[] frameBuffers = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
        GLUtils.checkGLError("GLUtils: createFbo");
        return frameBuffers[0];
    }

    public static void deleteFbo(int fbo) {
        if (fbo > 0) {
            GLES20.glDeleteFramebuffers((int)1, (int[])new int[fbo], (int)0);
        }
    }

    public static int genTexture(int texTarget) {
        int[] textureHandle = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandle, (int)0);
        GLUtils.checkGLError("GLUtils: glGenTextures");
        if (textureHandle[0] != 0) {
            GLES20.glBindTexture((int)texTarget, (int)textureHandle[0]);
            GLES20.glTexParameteri((int)texTarget, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)texTarget, (int)10243, (int)33071);
            GLES20.glTexParameteri((int)texTarget, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)texTarget, (int)10240, (int)9729);
        }
        return textureHandle[0];
    }

    public static void deleteTexture(int texId) {
        if (texId > 0) {
            GLES20.glDeleteTextures((int)1, (int[])new int[texId], (int)0);
        }
    }

    public static boolean checkGLError(String info) {
        int error = GLES20.glGetError();
        if (error != 0) {
            Logging.d(" " + info + " : " + android.opengl.GLUtils.getEGLErrorString((int)error));
            return true;
        }
        return false;
    }

    public static String texTargetToString(int texTarget) {
        if (texTarget == 36197) {
            return "texture_oes";
        }
        if (texTarget == 3553) {
            return "texture_2d";
        }
        return Integer.toString(texTarget);
    }
}

