/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf_mods;

import com.bytedance.bmf.ModuleFunctor;
import com.bytedance.bmf.ModuleInfo;
import com.bytedance.bmf_mods.Logging;
import com.bytedance.bmf_mods_api.VideoBrightAPI;
import com.bytedance.bmf_mods_api.VideoBrightCallbackAPI;
import com.google.gson.JsonObject;
import com.ss.android.ugc.aweme.framework.services.annotation.ServiceImpl;

@ServiceImpl(service={VideoBrightAPI.class}, singleton=true)
public class VideoBright
implements VideoBrightAPI {
    private JsonObject srOption = new JsonObject();
    private ModuleInfo srModuleInfo = null;
    private ModuleFunctor srFunc = null;
    private int oes_flag = 0;
    private static volatile boolean sIsSoInitialized = false;
    private int bright_status = 0;
    private int status_change = 0;
    private VideoBrightCallbackAPI sCallback = null;

    public VideoBright() {
        Logging.d("New VideoBright");
    }

    @Override
    public boolean Init(int init_fps, int normal_fps, int long_sw, int lum_thre) {
        if (!sIsSoInitialized) {
            return false;
        }
        this.srOption.addProperty("init_fps", (Number)init_fps);
        this.srOption.addProperty("normal_fps", (Number)normal_fps);
        this.srOption.addProperty("long_sw", (Number)long_sw);
        this.srOption.addProperty("lum_thre", (Number)lum_thre);
        this.srModuleInfo = new ModuleInfo("Brighten_Module", "c++", "libbmf_hydra.so", "");
        Class[] itypes = new Class[]{JsonObject.class};
        Class[] otypes = new Class[]{JsonObject.class};
        try {
            Logging.d("Brighten_Module: load bright Module");
            this.srFunc = new ModuleFunctor(this.srModuleInfo, this.srOption, itypes, otypes);
            Logging.d("Brighten_Module: load bright Module success");
        }
        catch (Exception e) {
            Logging.d("Brighten_Module: load bright Module failed," + e.toString());
            return false;
        }
        return true;
    }

    @Override
    public void SetCallback(VideoBrightCallbackAPI callback) {
        this.sCallback = callback;
    }

    @Override
    public int Process(int textureId, int otextureId, int width, int height, long timestamp) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.srFunc == null) {
            return -1;
        }
        JsonObject input = new JsonObject();
        input.addProperty("input_texture", (Number)textureId);
        input.addProperty("output_texture", (Number)otextureId);
        input.addProperty("width", (Number)width);
        input.addProperty("height", (Number)height);
        input.addProperty("timestamp", (Number)timestamp);
        JsonObject output = null;
        try {
            Object[] objs = this.srFunc.call(input);
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("Brighten_Module: call bright module failed," + e.toString());
            e.printStackTrace();
            return -1;
        }
        int output_texture = output.get("output_texture").getAsInt();
        int output_status = output.get("status").getAsInt();
        if (output_status == 2) {
            float cost_time = output.get("process_time").getAsFloat();
            float bright_before = output.get("input_texture_brightness").getAsFloat();
            float bright_after = output.get("output_texture_brightness").getAsFloat();
            if (this.sCallback != null) {
                this.sCallback.callback(output_status, cost_time, bright_before, bright_after);
            }
        }
        return output_texture;
    }

    @Override
    public int GetStatus() {
        return -1;
    }

    @Override
    public void Free() {
        if (this.srFunc != null) {
            this.srFunc.free();
        }
    }

    static {
        try {
            System.loadLibrary("hmp");
            System.loadLibrary("bmf_module_sdk");
            System.loadLibrary("bmf_hydra");
            sIsSoInitialized = true;
            Logging.d("video bright module is initialized");
        }
        catch (Throwable t) {
            Logging.d("video bright module initialize occurs error, the msg =" + t.getMessage());
            sIsSoInitialized = false;
        }
    }
}

