/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf_mods;

import android.graphics.Bitmap;
import com.bytedance.bmf.ModuleFunctor;
import com.bytedance.bmf.ModuleInfo;
import com.bytedance.bmf.VideoFrame;
import com.bytedance.bmf_mods.Logging;
import com.bytedance.bmf_mods_api.VideoOCLSRAPI;
import com.bytedance.hmp.Frame;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ss.android.ugc.aweme.framework.services.annotation.ServiceImpl;

@ServiceImpl(service={VideoOCLSRAPI.class}, singleton=true)
public class VideoOCLSR
implements VideoOCLSRAPI {
    private JsonObject srOption = new JsonObject();
    private ModuleInfo srModuleInfo = null;
    private ModuleFunctor srFunc = null;
    private int oes_flag = 0;
    private static volatile boolean sIsSoInitialized = false;

    public VideoOCLSR() {
        Logging.d("New VideoOCLSR");
    }

    @Override
    public boolean Init(String kernelBinPath, int algType, boolean isExtOESTexture, int maxInputWidth, int maxInputHeight) {
        return this.Init(kernelBinPath, algType, isExtOESTexture, maxInputWidth, maxInputHeight, 0);
    }

    @Override
    public boolean Init(String kernelBinPath, int algType, boolean isExtOESTexture, int maxInputWidth, int maxInputHeight, int format) {
        if (!sIsSoInitialized) {
            return false;
        }
        if (isExtOESTexture) {
            this.oes_flag = 1;
        }
        this.srOption.addProperty("config_path", kernelBinPath);
        int SR_R_TYPE = 0;
        int SR_R15_TYPE = 4;
        if (algType == SR_R_TYPE) {
            this.srOption.addProperty("scale", (Number)2.0);
        } else if (algType == SR_R15_TYPE) {
            this.srOption.addProperty("scale", (Number)1.5);
        } else {
            Logging.d("VideoOCLSR: unsupported algoType=%d" + algType);
            return false;
        }
        this.srOption.addProperty("max_input_width", (Number)maxInputWidth);
        this.srOption.addProperty("max_input_height", (Number)maxInputHeight);
        this.srOption.addProperty("filter_path", "");
        this.srOption.addProperty("format", (Number)format);
        this.srOption.addProperty("color", (Number)1);
        this.srOption.addProperty("power", (Number)4);
        this.srOption.addProperty("backend", (Number)2);
        this.srOption.addProperty("pipeline", (Number)1);
        this.srOption.addProperty("oes_flag", (Number)this.oes_flag);
        this.srModuleInfo = new ModuleInfo("VRSR_Module", "c++", "libvrsr.so", "");
        Class[] itypes = new Class[]{JsonObject.class};
        Class[] otypes = new Class[]{JsonObject.class};
        if (format == 1) {
            itypes[0] = VideoFrame.class;
            otypes[0] = VideoFrame.class;
        }
        try {
            Logging.d("VideoOCLSR: load VRSR Module");
            this.srFunc = new ModuleFunctor(this.srModuleInfo, this.srOption, itypes, otypes);
            Logging.d("VideoOCLSR: load VRSR Module success");
        }
        catch (Exception e) {
            Logging.d("VideoOCLSR: load VRSR Module failed," + e.toString());
            return false;
        }
        return true;
    }

    @Override
    public int Process(int textureId, int otextureId, int width, int height, boolean open) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.srFunc == null) {
            return -1;
        }
        JsonObject input = new JsonObject();
        input.addProperty("input_texture", (Number)textureId);
        input.addProperty("output_texture", (Number)otextureId);
        input.addProperty("width", (Number)width);
        input.addProperty("height", (Number)height);
        JsonObject output = null;
        try {
            Object[] objs = this.srFunc.call(input);
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("VideoOCLSR: call VRSR module failed, %s" + e.toString());
            e.printStackTrace();
            return -1;
        }
        return otextureId;
    }

    @Override
    public int OesProcess(int textureId, int otextureId, int width, int height, float[] matrix, boolean open) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.srFunc == null) {
            return -1;
        }
        JsonObject input = new JsonObject();
        input.addProperty("input_texture", (Number)textureId);
        input.addProperty("output_texture", (Number)otextureId);
        input.addProperty("width", (Number)width);
        input.addProperty("height", (Number)height);
        if (this.oes_flag == 1) {
            JsonArray jsonArray = new JsonArray();
            for (float n : matrix) {
                jsonArray.add((Number)Float.valueOf(n));
            }
            input.add("matrix", (JsonElement)jsonArray);
        }
        JsonObject output = null;
        try {
            Object[] objs = this.srFunc.call(input);
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("VideoOCLSR: call VRSR module failed," + e.toString());
            e.printStackTrace();
            return -1;
        }
        return otextureId;
    }

    @Override
    public Bitmap Process(Bitmap srcBmp, int width, int height, boolean open) {
        if (!sIsSoInitialized) {
            return null;
        }
        if (this.srFunc == null) {
            return null;
        }
        VideoFrame input = new VideoFrame(new Frame(srcBmp));
        VideoFrame output = null;
        try {
            Object[] objs = this.srFunc.call(input);
            output = (VideoFrame)objs[0];
        }
        catch (Exception e) {
            input.free();
            Logging.d("VideoOCLSR: call VRSR module failed," + e.toString());
            e.printStackTrace();
            return null;
        }
        Bitmap dstBmp = Bitmap.createBitmap((int)output.width(), (int)output.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        VideoFrame destVF = new VideoFrame(new Frame(dstBmp));
        destVF.copyFrom(output);
        input.free();
        output.free();
        destVF.free();
        return dstBmp;
    }

    @Override
    public void Free() {
        if (this.srFunc != null) {
            this.srFunc.free();
        }
    }

    static {
        try {
            System.loadLibrary("hmp");
            System.loadLibrary("bmf_module_sdk");
            System.loadLibrary("vrsr");
            sIsSoInitialized = true;
            Logging.d("videoOCLSR is initialized");
        }
        catch (Throwable t) {
            Logging.d("videoOCLSR initialize occurs error, the msg = " + t.getMessage());
            sIsSoInitialized = false;
        }
    }
}

