/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf_mods;

import android.opengl.GLES20;
import com.bytedance.bmf.ModuleFunctor;
import com.bytedance.bmf.ModuleInfo;
import com.bytedance.bmf_mods.GLUtils;
import com.bytedance.bmf_mods.Logging;
import com.bytedance.bmf_mods_api.VideoSRLutAPI;
import com.google.gson.JsonObject;
import com.ss.android.ugc.aweme.framework.services.annotation.ServiceImpl;

@ServiceImpl(service={VideoSRLutAPI.class}, singleton=true)
public class VideoSRLut
implements VideoSRLutAPI {
    private JsonObject srOption = new JsonObject();
    private ModuleInfo srModuleInfo = null;
    private ModuleFunctor srFunc = null;
    private int oes_flag = 0;
    private static volatile boolean sIsSoInitialized = false;
    private int SR_R_TYPE = 0;
    private int SR_R15_TYPE = 4;
    private int currWidth;
    private int currHeight;
    private int algType;
    private int currOutputTexture;

    public VideoSRLut() {
        Logging.d("New VideoSRLut");
    }

    @Override
    public boolean Init(int algType) {
        if (!sIsSoInitialized) {
            return false;
        }
        if (algType != this.SR_R_TYPE) {
            Logging.d("VideoSRLut: unsupported algoType=" + algType);
            return false;
        }
        this.srOption.addProperty("scale", (Number)2.0);
        this.srOption.addProperty("data_type", (Number)1);
        this.srModuleInfo = new ModuleInfo("SR_LUT_Module", "c++", "libbmf_hydra.so", "");
        Class[] itypes = new Class[]{JsonObject.class};
        Class[] otypes = new Class[]{JsonObject.class};
        try {
            Logging.d("VideoSRLut: load SRLut Module");
            this.srFunc = new ModuleFunctor(this.srModuleInfo, this.srOption, itypes, otypes);
            Logging.d("VideoSRLut: load SRLut Module success");
        }
        catch (Exception e) {
            Logging.d("VideoSRLut: load video sr lut Module failed," + e.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean Init(String kernelBinPath, int algType, boolean isExtOESTexture, int maxInputWidth, int maxInputHeight) {
        if (!sIsSoInitialized) {
            return false;
        }
        if (isExtOESTexture) {
            this.oes_flag = 1;
        }
        if (algType != this.SR_R_TYPE) {
            Logging.d("VideoSRLut: unsupported algoType=" + algType);
            return false;
        }
        this.srOption.addProperty("scale", (Number)2.0);
        this.srModuleInfo = new ModuleInfo("SR_LUT_Module", "c++", "libbmf_hydra.so", "");
        Class[] itypes = new Class[]{JsonObject.class};
        Class[] otypes = new Class[]{JsonObject.class};
        try {
            Logging.d("VideoSRLut: load SRLut Module");
            this.srFunc = new ModuleFunctor(this.srModuleInfo, this.srOption, itypes, otypes);
            Logging.d("VideoSRLut: load SRLut Module success");
        }
        catch (Exception e) {
            Logging.d("VideoSRLut: load video sr lut Module failed," + e.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean Init(String kernelBinPath, int algType, boolean isExtOESTexture, int maxInputWidth, int maxInputHeight, String licenseModuleName) {
        if (!sIsSoInitialized) {
            return false;
        }
        if (isExtOESTexture) {
            this.oes_flag = 1;
        }
        if (algType != this.SR_R_TYPE) {
            Logging.d(String.format("VideoSRLut: unsupported algoType=%d", algType));
            return false;
        }
        this.srOption.addProperty("scale", (Number)2.0);
        this.srOption.addProperty("license_module_name", licenseModuleName);
        this.srModuleInfo = new ModuleInfo("SR_LUT_Module", "c++", "libbmf_hydra.so", "");
        Class[] itypes = new Class[]{JsonObject.class};
        Class[] otypes = new Class[]{JsonObject.class};
        try {
            Logging.d("VideoSRLut: load SRLut Module");
            this.srFunc = new ModuleFunctor(this.srModuleInfo, this.srOption, itypes, otypes);
            Logging.d("VideoSRLut: load SRLut Module success");
        }
        catch (Exception e) {
            Logging.d(String.format("VideoSRLut: load video sr lut Module failed, %s", e.toString()));
            return false;
        }
        return true;
    }

    @Override
    public boolean GlSrInit(String kernelBinPath, int algType, boolean isExtOESTexture, int maxInputWidth, int maxInputHeight) {
        long startTime = System.currentTimeMillis();
        if (!sIsSoInitialized) {
            return false;
        }
        if (isExtOESTexture) {
            this.oes_flag = 1;
        }
        int SR_R_TYPE = 0;
        int SR_R15_TYPE = 4;
        if (algType != SR_R_TYPE) {
            Logging.d(String.format("VideoSRLut: unsupported algoType=%d", algType));
            return false;
        }
        this.srOption.addProperty("scale", (Number)2.0);
        this.srOption.addProperty("gl_sr", (Number)1);
        this.srModuleInfo = new ModuleInfo("SR_LUT_Module", "c++", "libbmf_hydra.so", "");
        Class[] itypes = new Class[]{JsonObject.class};
        Class[] otypes = new Class[]{JsonObject.class};
        try {
            Logging.d("VideoSRLut: load VRSR Module");
            this.srFunc = new ModuleFunctor(this.srModuleInfo, this.srOption, itypes, otypes);
            Logging.d("VideoSRLut: load VRSR Module success");
        }
        catch (Exception e) {
            Logging.d(String.format("VideoSRLut: load video sr lut Module failed, %s", e.toString()));
            return false;
        }
        long endTime = System.currentTimeMillis();
        Logging.d(String.format("BMF_gl_sr proces time:%d ms", endTime - startTime));
        return true;
    }

    @Override
    public int Process(int textureId, int otextureId, int width, int height, boolean open) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.srFunc == null) {
            return -1;
        }
        JsonObject input = new JsonObject();
        input.addProperty("input_texture", (Number)textureId);
        input.addProperty("output_texture", (Number)otextureId);
        input.addProperty("width", (Number)width);
        input.addProperty("height", (Number)height);
        JsonObject output = null;
        try {
            Object[] objs = this.srFunc.call(input);
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("VideoSRLut: call SRLut module failed, " + e.toString());
            e.printStackTrace();
            return -1;
        }
        return otextureId;
    }

    @Override
    public int Process(long dataY, long dataU, long dataV, int colorSpace, int colorRange, int width, int height) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.srFunc == null) {
            return -1;
        }
        if (width != this.currWidth || height != this.currHeight) {
            GLUtils.deleteTexture(this.currOutputTexture);
            this.currWidth = width;
            this.currHeight = height;
            double scale = this.algType == 0 ? 2.0 : 1.5;
            int oWidth = (int)(scale * (double)this.currWidth);
            int oHeight = (int)(scale * (double)this.currHeight);
            this.currOutputTexture = GLUtils.genTexture(3553);
            GLES20.glBindTexture((int)3553, (int)this.currOutputTexture);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)oWidth, (int)oHeight, (int)0, (int)6408, (int)5121, null);
            GLES20.glBindTexture((int)3553, (int)0);
        }
        JsonObject input = new JsonObject();
        input.addProperty("y_ptr", (Number)dataY);
        input.addProperty("u_ptr", (Number)dataU);
        input.addProperty("v_ptr", (Number)dataV);
        input.addProperty("color_space", (Number)colorSpace);
        input.addProperty("color_range", (Number)colorRange);
        input.addProperty("output_texture", (Number)this.currOutputTexture);
        input.addProperty("width", (Number)width);
        input.addProperty("height", (Number)height);
        JsonObject output = null;
        try {
            Object[] objs = this.srFunc.call(input);
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("VideoSRLut: call SRLut module failed, " + e.toString());
            e.printStackTrace();
            return -1;
        }
        return this.currOutputTexture;
    }

    @Override
    public int AsyncProcess(int textureId, int otextureId, int width, int height, boolean open) {
        if (this.srFunc == null) {
            return -1;
        }
        JsonObject input = new JsonObject();
        input.addProperty("input_texture", (Number)textureId);
        input.addProperty("output_texture", (Number)otextureId);
        input.addProperty("width", (Number)width);
        input.addProperty("height", (Number)height);
        input.addProperty("async", (Number)1);
        JsonObject output = null;
        try {
            Logging.d("VideoSRLut: async call");
            Object[] objs = this.srFunc.call(input);
            Logging.d("VideoSRLut: async call end");
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("VideoSRLut: async call VRSR module failed, " + e.toString());
            e.printStackTrace();
            return -1;
        }
        return otextureId;
    }

    @Override
    public int AsyncWait() {
        if (this.srFunc == null) {
            return -1;
        }
        JsonObject input = new JsonObject();
        input.addProperty("async_wait", (Number)1);
        JsonObject output = null;
        try {
            Logging.d("VideoSRLut: async process, wait.");
            Object[] objs = this.srFunc.call(input);
            Logging.d("VideoSRLut: async wait finish.");
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("VideoSRLut: call VRSR module failed, %s" + e.toString());
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    @Override
    public int ClearClBuffer() {
        if (this.srFunc == null) {
            return -1;
        }
        JsonObject input = new JsonObject();
        input.addProperty("clear_cl_buffer", (Number)1);
        JsonObject output = null;
        try {
            Logging.d("VideoSRLut: clear opencl buffer start.");
            Object[] objs = this.srFunc.call(input);
            Logging.d("VideoSRLut: clear opencl buffer finish.");
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("VideoSRLut: clear opencl buffer failed," + e.toString());
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    @Override
    public void Free() {
        if (this.srFunc != null) {
            this.srFunc.free();
        }
    }

    static {
        try {
            System.loadLibrary("hmp");
            System.loadLibrary("bmf_module_sdk");
            System.loadLibrary("bmf_hydra");
            sIsSoInitialized = true;
            Logging.d("video srlut is initialized");
        }
        catch (Throwable t) {
            Logging.d("video srlut initialize occurs error, the msg = " + t.getMessage());
            sIsSoInitialized = false;
        }
    }
}

