/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf_mods;

import com.bytedance.bmf.ModuleFunctor;
import com.bytedance.bmf.ModuleInfo;
import com.bytedance.bmf_mods.Logging;
import com.bytedance.bmf_mods_api.VideoSRLutDspAPI;
import com.google.gson.JsonObject;
import com.ss.android.ugc.aweme.framework.services.annotation.ServiceImpl;

@ServiceImpl(service={VideoSRLutDspAPI.class}, singleton=true)
public class VideoSRLutDsp
implements VideoSRLutDspAPI {
    private JsonObject srOption = new JsonObject();
    private ModuleInfo srModuleInfo = null;
    private ModuleFunctor srFunc = null;
    private static volatile boolean sIsSoInitialized = false;
    private int currWidth;
    private int currHeight;
    private int currInputTexture = -1;
    private int currOutputTexture = -1;

    public VideoSRLutDsp() {
        Logging.d("New VideoSRLutDsp.");
    }

    @Override
    public boolean Init(int width, int height, String dsp_so_path) {
        this.srModuleInfo = new ModuleInfo("SrLutDspModule", "c++", "libbmf_hydra.so", "");
        Class[] itypes = new Class[]{JsonObject.class};
        Class[] otypes = new Class[]{JsonObject.class};
        this.srOption.addProperty("width", (Number)width);
        this.srOption.addProperty("height", (Number)height);
        this.currWidth = width;
        this.currHeight = height;
        if (dsp_so_path != null && dsp_so_path != "") {
            this.srOption.addProperty("dsp_so_path", dsp_so_path);
        }
        try {
            Logging.d("VideoSRLutDsp init: load VRSR Module");
            this.srFunc = new ModuleFunctor(this.srModuleInfo, this.srOption, itypes, otypes);
            Logging.d("VideoSRLut initDsp: load VRSR Module success");
        }
        catch (Exception e) {
            Logging.d("VideoSRLutDsp init: load video sr lut Module failed," + e.toString());
            return false;
        }
        return true;
    }

    @Override
    public int[] GetTextures() {
        JsonObject input = new JsonObject();
        input.addProperty("get_textures", (Number)1);
        JsonObject output = null;
        int[] ret = new int[]{-1, -1};
        if (this.srFunc == null) {
            return ret;
        }
        try {
            Logging.d("VideoSRLutDsp: call GetTextures.");
            Object[] objs = this.srFunc.call(input);
            Logging.d("VideoSRLutDsp: GetTextures end.");
            output = (JsonObject)objs[0];
            ret[0] = output.get("input_texture").getAsInt();
            ret[1] = output.get("output_texture").getAsInt();
            this.currInputTexture = ret[0];
            this.currOutputTexture = ret[1];
        }
        catch (Exception e) {
            Logging.d(String.format("VideoSRLut: call VRSR module failed, %s", e.toString()));
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public int Process() {
        JsonObject input = new JsonObject();
        JsonObject output = null;
        if (this.srFunc == null) {
            return -1;
        }
        try {
            Logging.d("VideoSRLutDsp: call dsp process");
            Object[] objs = this.srFunc.call(input);
            Logging.d("VideoSRLutDsp: dsp process end");
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d(String.format("VideoSRLutDsp: call VRSR module failed, %s", e.toString()));
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    @Override
    public void Free() {
        if (this.srFunc != null) {
            this.srFunc.free();
        }
    }

    static {
        try {
            System.loadLibrary("hmp");
            System.loadLibrary("bmf_module_sdk");
            System.loadLibrary("bmf_hydra");
            sIsSoInitialized = true;
            Logging.d("video srlut dsp is initialized");
        }
        catch (Throwable t) {
            Logging.d("video srlut dsp initialize occurs error, the msg = " + t.getMessage());
            sIsSoInitialized = false;
        }
    }
}

