/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf_mods;

import android.graphics.Bitmap;
import com.bytedance.bmf.ModuleFunctor;
import com.bytedance.bmf.ModuleInfo;
import com.bytedance.bmf_mods.Logging;
import com.bytedance.bmf_mods_api.VideoSRRaisrAPI;
import com.bytedance.hmp.ChannelFormat;
import com.bytedance.hmp.Frame;
import com.bytedance.hmp.Image;
import com.bytedance.hmp.PixelFormat;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ss.android.ugc.aweme.framework.services.annotation.ServiceImpl;

@ServiceImpl(service={VideoSRRaisrAPI.class}, singleton=true)
public class VideoSRRaisr
implements VideoSRRaisrAPI {
    private JsonObject srOption = new JsonObject();
    private ModuleInfo srModuleInfo = null;
    private ModuleFunctor srFunc = null;
    private int data_type = 0;
    private int scale_type;
    private final int SR_R_TYPE = 0;
    private final int SR_R15_TYPE = 4;
    private static volatile boolean sIsSoInitialized = false;

    public VideoSRRaisr() {
        Logging.d("New VideoSRRaisr");
    }

    @Override
    public boolean Init(String kernelBinPath, int algType, boolean isExtOESTexture, int maxInputWidth, int maxInputHeight) {
        return this.Init(kernelBinPath, algType, isExtOESTexture, maxInputWidth, maxInputHeight, 0);
    }

    @Override
    public boolean Init(String kernelBinPath, int algType, boolean isExtOESTexture, int maxInputWidth, int maxInputHeight, int format) {
        if (!sIsSoInitialized) {
            return false;
        }
        if (isExtOESTexture) {
            if (format == 1) {
                Logging.d("SR_RAISR_Module: data type cannot transfer to OES texture");
                return false;
            }
            this.data_type = 2;
        } else {
            this.data_type = format == 1 ? 1 : 0;
        }
        if (algType == 0) {
            this.scale_type = 1;
        } else if (algType == 4) {
            this.scale_type = 0;
        } else {
            Logging.d("SR_RAISR_Module: algType param is neither 4 nor 0");
            return false;
        }
        this.srOption.addProperty("scale_type", (Number)this.scale_type);
        this.srOption.addProperty("data_type", (Number)this.data_type);
        this.srModuleInfo = new ModuleInfo("SR_RAISR_Module", "c++", "libbmf_hydra.so", "");
        Class[] itypes = new Class[]{JsonObject.class};
        Class[] otypes = new Class[]{JsonObject.class};
        try {
            Logging.d("SR_RAISR_Module: load raisr Module");
            this.srFunc = new ModuleFunctor(this.srModuleInfo, this.srOption, itypes, otypes);
            Logging.d("SR_RAISR_Module: load raisr Module success");
        }
        catch (Exception e) {
            Logging.d("SR_RAISR_Module: load raisr Module failed," + e.toString());
            return false;
        }
        return true;
    }

    @Override
    public int Process(int textureId, int otextureId, int width, int height, boolean open) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.data_type != 0) {
            Logging.d("SR_RAISR_Module: Process function only receive texture2D");
            return -1;
        }
        if (this.srFunc == null) {
            Logging.d("SR_RAISR_Module: ModuleFunctor is null");
            return -1;
        }
        JsonObject input = new JsonObject();
        input.addProperty("input_texture", (Number)textureId);
        input.addProperty("output_texture", (Number)otextureId);
        input.addProperty("width", (Number)width);
        input.addProperty("height", (Number)height);
        JsonObject output = null;
        try {
            Object[] objs = this.srFunc.call(input);
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("VideoSRRaisr: call raisr module failed," + e.toString());
            e.printStackTrace();
            return -1;
        }
        return otextureId;
    }

    @Override
    public int OesProcess(int textureId, int otextureId, int width, int height, float[] matrix, boolean open) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.data_type != 2) {
            Logging.d("SR_RAISR_Module: OesProcess function only receive oes texture");
            return -1;
        }
        if (this.srFunc == null) {
            Logging.d("SR_RAISR_Module: ModuleFunctor is null");
            return -1;
        }
        JsonObject input = new JsonObject();
        input.addProperty("input_texture", (Number)textureId);
        input.addProperty("output_texture", (Number)otextureId);
        input.addProperty("width", (Number)width);
        input.addProperty("height", (Number)height);
        JsonArray jsonArray = new JsonArray();
        for (float n : matrix) {
            jsonArray.add((Number)Float.valueOf(n));
        }
        input.add("matrix", (JsonElement)jsonArray);
        JsonObject output = null;
        try {
            Object[] objs = this.srFunc.call(input);
            output = (JsonObject)objs[0];
        }
        catch (Exception e) {
            Logging.d("VideoSRRaisr: call raisr module failed," + e.toString());
            e.printStackTrace();
            return -1;
        }
        return otextureId;
    }

    @Override
    public Bitmap Process(Bitmap srcBmp, int width, int height, boolean open) {
        int outputHeight;
        int outputWidth;
        if (!sIsSoInitialized) {
            return null;
        }
        if (this.data_type != 1) {
            Logging.d("SR_RAISR_Module: only receive bitmap");
            return null;
        }
        if (this.srFunc == null) {
            Logging.d("SR_RAISR_Module: ModuleFunctor is null");
            return null;
        }
        Frame srcFrame = new Frame(srcBmp);
        Image srcImage = null;
        if (srcFrame.format() == PixelFormat.PF_RGBA32) {
            srcImage = srcFrame.toImage(ChannelFormat.kNHWC);
        }
        if (srcImage == null) {
            Logging.d("VideoSRRaisr: srcImage is null");
            return null;
        }
        int inputWidth = srcImage.width();
        int inputHeight = srcImage.height();
        long inputDataPtr = srcImage.data().dataPtr();
        if (this.scale_type == 0) {
            outputWidth = inputWidth / 2 * 3;
            outputHeight = inputHeight / 2 * 3;
        } else if (this.scale_type == 1) {
            outputWidth = inputWidth * 2;
            outputHeight = inputHeight * 2;
        } else {
            Logging.d("VideoSRRaisr: scale_type is neither 0 nor 1");
            return null;
        }
        Bitmap dstBmp = Bitmap.createBitmap((int)outputWidth, (int)outputHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Frame dstFrame = new Frame(dstBmp);
        Image dstImage = null;
        if (dstFrame.format() == PixelFormat.PF_RGBA32) {
            dstImage = dstFrame.toImage(ChannelFormat.kNHWC);
        }
        if (dstImage == null) {
            Logging.d("VideoSRRaisr: dstImage is null");
            return null;
        }
        long outputDataPtr = dstImage.data().dataPtr();
        JsonObject input = new JsonObject();
        input.addProperty("input_width", (Number)inputWidth);
        input.addProperty("input_height", (Number)inputHeight);
        input.addProperty("input_dataPtr", (Number)inputDataPtr);
        input.addProperty("output_dataPtr", (Number)outputDataPtr);
        try {
            Object[] objectArray = this.srFunc.call(input);
        }
        catch (Exception e) {
            Logging.d("VideoSRRaisr: call raisr module failed," + e.toString());
            e.printStackTrace();
            return null;
        }
        return dstBmp;
    }

    @Override
    public void Free() {
        if (this.srFunc != null) {
            this.srFunc.free();
        }
    }

    static {
        try {
            System.loadLibrary("hmp");
            System.loadLibrary("bmf_module_sdk");
            System.loadLibrary("bmf_hydra");
            sIsSoInitialized = true;
            Logging.d("video SR Raisr is initialized");
        }
        catch (Throwable t) {
            Logging.d("video SR Raisr initialize occurs error, the msg =" + t.getMessage());
            sIsSoInitialized = false;
        }
    }
}

