/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bmf_mods;

import com.bytedance.bmf.JsonParam;
import com.bytedance.bmf.ModuleFunctor;
import com.bytedance.bmf.ModuleInfo;
import com.bytedance.bmf_mods.Logging;
import com.bytedance.bmf_mods_api.VideoSuperResolutionAPI;
import com.google.gson.JsonObject;
import com.ss.android.ugc.aweme.framework.services.annotation.ServiceImpl;

@ServiceImpl(service={VideoSuperResolutionAPI.class}, singleton=true)
public class VideoSuperResolution
implements VideoSuperResolutionAPI {
    private JsonObject srOption = new JsonObject();
    private ModuleInfo srModuleInfo = null;
    private ModuleFunctor srFunc = null;
    private static volatile boolean sIsSoInitialized = false;

    public VideoSuperResolution() {
        Logging.d("New VideoSuperResolution");
    }

    @Override
    public int Init(int alg_type, int backend, int scale_type, int pool_size, String libpath, String licenseModuleName) {
        return this.Init(alg_type, backend, scale_type, pool_size, libpath, licenseModuleName, "");
    }

    @Override
    public int Init(int alg_type, int backend, int scale_type, int pool_size, String libpath, String licenseModuleName, String programCacheDir) {
        return this.Init(alg_type, backend, scale_type, pool_size, libpath, licenseModuleName, programCacheDir, 0, 0);
    }

    @Override
    public int Init(int alg_type, int backend, int scale_type, int pool_size, String libpath, String licenseModuleName, String programCacheDir, int max_width, int max_height) {
        if (!sIsSoInitialized) {
            return -1;
        }
        this.srOption.addProperty("backend", (Number)backend);
        this.srOption.addProperty("alg_type", (Number)alg_type);
        this.srOption.addProperty("scale_type", (Number)scale_type);
        if (pool_size <= 0) {
            Logging.d("VideoSuperResolution: pool size should be more than 0, change to 6 for default");
            pool_size = 6;
        }
        this.srOption.addProperty("pool_size", (Number)pool_size);
        this.srOption.addProperty("license_module_name", licenseModuleName);
        this.srOption.addProperty("program_cache_dir", programCacheDir);
        if (max_width > 0 && max_height > 0) {
            this.srOption.addProperty("max_width", (Number)max_width);
            this.srOption.addProperty("max_height", (Number)max_height);
        }
        this.srModuleInfo = new ModuleInfo("SuperResolutionModule", "c++", "libbmf_hydra.so", "");
        Class[] itypes = new Class[]{JsonParam.class};
        Class[] otypes = new Class[]{JsonParam.class};
        try {
            Logging.d("VideoSuperResolution: load VideoSuperResolution Module");
            this.srFunc = new ModuleFunctor(this.srModuleInfo, this.srOption, itypes, otypes);
            Logging.d("VideoSuperResolution: load VideoSuperResolution Module success");
        }
        catch (Exception e) {
            Logging.d(String.format("VideoSuperResolution: load VideoSuperResolution Module failed, %s", e.toString()));
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ProcessTexture(int textureId, int width, int height) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.srFunc == null) {
            return -1;
        }
        JsonParam input = new JsonParam();
        JsonParam output = null;
        int output_texture = -1;
        try {
            input.set("mode", 0);
            input.set("input_data_type", 0);
            input.set("input_texture", textureId);
            input.set("width", width);
            input.set("height", height);
            Object[] objs = this.srFunc.call(input);
            output = (JsonParam)objs[0];
            output_texture = output.getInt("output_texture");
        }
        catch (Exception e) {
            Logging.d("VideoSuperResolution: call VideoSuperResolution module failed, " + e.toString());
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            input.free();
            if (output != null) {
                output.free();
            }
        }
        return output_texture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ProcessOesTexture(int textureId, int width, int height, float[] matrix) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.srFunc == null) {
            return -1;
        }
        JsonParam input = new JsonParam();
        JsonParam output = null;
        int output_texture = -1;
        try {
            input.set("mode", 0);
            input.set("input_data_type", 2);
            input.set("input_texture", textureId);
            input.set("width", width);
            input.set("height", height);
            input.set("matrix", matrix);
            Object[] objs = this.srFunc.call(input);
            output = (JsonParam)objs[0];
            output_texture = output.getInt("output_texture");
        }
        catch (Exception e) {
            Logging.d("VideoSuperResolution: call VideoSuperResolution module failed, " + e.toString());
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            input.free();
            if (output != null) {
                output.free();
            }
        }
        return output_texture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ProcessYuv420p(long dataY, long dataU, long dataV, int colorSpace, int colorRange, int width, int height) {
        if (!sIsSoInitialized) {
            return -1;
        }
        if (this.srFunc == null) {
            return -1;
        }
        JsonParam input = new JsonParam();
        JsonParam output = null;
        int output_texture = -1;
        try {
            input.set("mode", 0);
            input.set("input_data_type", 3);
            input.set("y_ptr", dataY);
            input.set("u_ptr", dataU);
            input.set("v_ptr", dataV);
            input.set("color_space", colorSpace);
            input.set("color_range", colorRange);
            input.set("width", width);
            input.set("height", height);
            Object[] objs = this.srFunc.call(input);
            output = (JsonParam)objs[0];
            output_texture = output.getInt("output_texture");
        }
        catch (Exception e) {
            Logging.d("VideoSuperResolution: call VideoSuperResolution module failed, " + e.toString());
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            input.free();
            if (output != null) {
                output.free();
            }
        }
        return output_texture;
    }

    @Override
    public void Free() {
        if (this.srFunc != null) {
            this.srFunc.free();
        }
    }

    static {
        try {
            System.loadLibrary("hmp");
            System.loadLibrary("bmf_module_sdk");
            System.loadLibrary("bmf_hydra");
            sIsSoInitialized = true;
            Logging.d("VideoSuperResolution is initialized");
        }
        catch (Throwable t) {
            Logging.d("VideoSuperResolution initialize occurs error, the msg = " + t.getMessage());
            sIsSoInitialized = false;
        }
    }
}

