/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.hmp;

import com.bytedance.hmp.Api;
import com.bytedance.hmp.ColorPrimaries;
import com.bytedance.hmp.ColorRange;
import com.bytedance.hmp.ColorSpace;
import com.bytedance.hmp.ColorTransferCharacteristic;
import com.bytedance.hmp.EnumUtil;
import com.bytedance.hmp.Ptr;

public class ColorModel
extends Ptr {
    public static ColorModel wrap(long ptr, boolean own) {
        return new ColorModel(ptr, own);
    }

    private ColorModel(long ptr_, boolean own_) {
        this.ptr = ptr_;
        this.own = own_;
    }

    public ColorModel(ColorSpace cs, ColorRange cr, ColorPrimaries cp, ColorTransferCharacteristic ctc) {
        this.ptr = Api.color_model_make(cs.getValue(), cr.getValue(), cp.getValue(), ctc.getValue());
        this.own = true;
    }

    public void free() {
        if (this.own) {
            Api.color_model_free(this.ptr);
        }
    }

    public ColorSpace space() {
        int v = Api.color_model_space(this.ptr);
        return (ColorSpace)((Object)EnumUtil.fromValue(ColorSpace.class, v));
    }

    public ColorRange range() {
        int v = Api.color_model_range(this.ptr);
        return (ColorRange)((Object)EnumUtil.fromValue(ColorRange.class, v));
    }

    public ColorPrimaries primaries() {
        int v = Api.color_model_primaries(this.ptr);
        return (ColorPrimaries)((Object)EnumUtil.fromValue(ColorPrimaries.class, v));
    }

    public ColorTransferCharacteristic colorTransferCharacteristic() {
        int v = Api.color_model_ctc(this.ptr);
        return (ColorTransferCharacteristic)((Object)EnumUtil.fromValue(ColorTransferCharacteristic.class, v));
    }
}

