/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.hmp;

import com.bytedance.hmp.Api;
import com.bytedance.hmp.DeviceType;
import com.bytedance.hmp.EnumUtil;
import com.bytedance.hmp.Ptr;

public class Device
extends Ptr {
    public static Device wrap(long ptr, boolean own) {
        return new Device(ptr, own);
    }

    private Device(long ptr_, boolean own_) {
        this.ptr = ptr_;
        this.own = own_;
    }

    public Device() {
        this.ptr = Api.device_make("");
        this.own = true;
    }

    public Device(String device) {
        this.ptr = Api.device_make(device);
        this.own = true;
    }

    public Device(DeviceType device, int index) {
        this.ptr = Api.device_make(device.getValue(), index);
        this.own = true;
    }

    public void free() {
        if (this.own) {
            Api.device_free(this.ptr);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Device) {
            Device dother = (Device)other;
            return this.type() == dother.type() && this.index() == dother.index();
        }
        return false;
    }

    public DeviceType type() {
        int v = Api.device_type(this.ptr);
        return (DeviceType)((Object)EnumUtil.fromValue(DeviceType.class, v));
    }

    public int index() {
        return Api.device_index(this.ptr);
    }

    public String toString() {
        return Api.device_stringfy(this.ptr);
    }

    public static int count(DeviceType deviceType) {
        return Api.device_count(deviceType.getValue());
    }

    public static boolean hasCuda() {
        return Device.count(DeviceType.kCUDA) > 0;
    }

    public class Guard
    extends Ptr {
        public Guard() {
            this.ptr = Api.device_guard_make(Device.this.ptr);
            this.own = true;
        }

        public void free() {
            if (this.own) {
                Api.device_guard_free(this.ptr);
            }
        }
    }
}

