/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.hmp;

import android.graphics.Bitmap;
import com.bytedance.hmp.Api;
import com.bytedance.hmp.ChannelFormat;
import com.bytedance.hmp.Device;
import com.bytedance.hmp.DeviceType;
import com.bytedance.hmp.EnumUtil;
import com.bytedance.hmp.Image;
import com.bytedance.hmp.PixelFormat;
import com.bytedance.hmp.PixelInfo;
import com.bytedance.hmp.Ptr;
import com.bytedance.hmp.ScalarType;
import com.bytedance.hmp.Tensor;

public class Frame
extends Ptr {
    public static Frame wrap(long ptr, boolean own) {
        return new Frame(ptr, own);
    }

    private Frame(long ptr_, boolean own_) {
        this.ptr = ptr_;
        this.own = own_;
    }

    public Frame(int width, int height, PixelInfo pix_info, String device) {
        this.ptr = Api.frame_make(width, height, pix_info.getPtr(), device);
        this.own = true;
    }

    public Frame(int width, int height, PixelInfo pix_info, Device device) {
        this.ptr = Api.frame_make(width, height, pix_info.getPtr(), device.toString());
        this.own = true;
    }

    public Frame(Tensor[] data, PixelInfo pix_info) {
        long[] dptrs = new long[data.length];
        for (int i = 0; i < data.length; ++i) {
            dptrs[i] = data[i].getPtr();
        }
        this.ptr = Api.frame_make(dptrs, pix_info.getPtr());
        this.own = true;
    }

    public Frame(Bitmap bitmap) {
        this.ptr = Api.frame_make(bitmap);
        this.own = true;
    }

    public Frame(Tensor[] data, int width, int height, PixelInfo pix_info) {
        long[] dptrs = new long[data.length];
        for (int i = 0; i < data.length; ++i) {
            dptrs[i] = data[i].getPtr();
        }
        this.ptr = Api.frame_make(dptrs, width, height, pix_info.getPtr());
        this.own = true;
    }

    public void free() {
        if (this.own) {
            Api.frame_free(this.ptr);
        }
    }

    public boolean defined() {
        return Api.frame_defined(this.ptr);
    }

    public PixelInfo pixInfo() {
        return PixelInfo.wrap(Api.frame_pix_info(this.ptr), false);
    }

    public PixelFormat format() {
        int v = Api.frame_format(this.ptr);
        return (PixelFormat)((Object)EnumUtil.fromValue(PixelFormat.class, v));
    }

    public int width() {
        return Api.frame_width(this.ptr);
    }

    public int height() {
        return Api.frame_height(this.ptr);
    }

    public ScalarType dtype() {
        int v = Api.frame_dtype(this.ptr);
        return (ScalarType)((Object)EnumUtil.fromValue(ScalarType.class, v));
    }

    public DeviceType deviceType() {
        int v = Api.frame_device_type(this.ptr);
        return (DeviceType)((Object)EnumUtil.fromValue(DeviceType.class, v));
    }

    public int deviceIndex() {
        return Api.frame_device_index(this.ptr);
    }

    public int nplanes() {
        return Api.frame_nplanes(this.ptr);
    }

    public Tensor plane(int p) {
        long data = Api.frame_plane(this.ptr, p);
        return Tensor.wrap(data, false);
    }

    public Frame to(String device, boolean nonBlocking) {
        return Frame.wrap(Api.frame_to_device(this.ptr, device, nonBlocking), true);
    }

    public Frame to(Device device, boolean nonBlocking) {
        return this.to(device.toString(), nonBlocking);
    }

    public void copyFrom(Frame from) {
        Api.frame_copy_from(this.ptr, from.getPtr());
    }

    public Frame clone() {
        return Frame.wrap(Api.frame_clone(this.ptr), true);
    }

    public Frame crop(int left, int top, int width, int height) {
        return Frame.wrap(Api.frame_crop(this.ptr, left, top, width, height), true);
    }

    public Image toImage(ChannelFormat cformat) {
        return Image.wrap(Api.frame_to_image(this.ptr, cformat.getValue()), true);
    }

    public String toString() {
        return Api.frame_stringfy(this.ptr);
    }

    public static Frame fromImage(Image image, PixelInfo pixInfo) {
        return Frame.wrap(Api.frame_from_image(image.getPtr(), pixInfo.getPtr()), true);
    }
}

