/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.hmp;

import com.bytedance.hmp.Api;
import com.bytedance.hmp.ColorModel;
import com.bytedance.hmp.ColorPrimaries;
import com.bytedance.hmp.ColorRange;
import com.bytedance.hmp.ColorSpace;
import com.bytedance.hmp.ColorTransferCharacteristic;
import com.bytedance.hmp.EnumUtil;
import com.bytedance.hmp.PixelFormat;
import com.bytedance.hmp.Ptr;

public class PixelInfo
extends Ptr {
    public static PixelInfo wrap(long ptr, boolean own) {
        return new PixelInfo(ptr, own);
    }

    private PixelInfo(long ptr_, boolean own_) {
        this.ptr = ptr_;
        this.own = own_;
    }

    public PixelInfo(PixelFormat format, ColorModel cm) {
        this.ptr = Api.pixel_info_make(format.getValue(), cm.getPtr());
        this.own = true;
    }

    public PixelInfo(PixelFormat format) {
        this.ptr = Api.pixel_info_make(format.getValue(), ColorSpace.CS_UNSPECIFIED.getValue(), ColorRange.CR_UNSPECIFIED.getValue());
        this.own = true;
    }

    public PixelInfo(PixelFormat format, ColorSpace cs, ColorRange cr) {
        this.ptr = Api.pixel_info_make(format.getValue(), cs.getValue(), cr.getValue());
        this.own = true;
    }

    public void free() {
        if (this.own) {
            Api.pixel_info_free(this.ptr);
        }
    }

    public PixelFormat format() {
        int v = Api.pixel_info_format(this.ptr);
        return (PixelFormat)((Object)EnumUtil.fromValue(PixelFormat.class, v));
    }

    public ColorSpace space() {
        int v = Api.pixel_info_space(this.ptr);
        return (ColorSpace)((Object)EnumUtil.fromValue(ColorSpace.class, v));
    }

    public ColorRange range() {
        int v = Api.pixel_info_range(this.ptr);
        return (ColorRange)((Object)EnumUtil.fromValue(ColorRange.class, v));
    }

    public ColorPrimaries primaries() {
        int v = Api.pixel_info_primaries(this.ptr);
        return (ColorPrimaries)((Object)EnumUtil.fromValue(ColorPrimaries.class, v));
    }

    public ColorTransferCharacteristic colorTransferCharacteristic() {
        int v = Api.pixel_info_primaries(this.ptr);
        return (ColorTransferCharacteristic)((Object)EnumUtil.fromValue(ColorTransferCharacteristic.class, v));
    }

    public ColorSpace inferSpace() {
        int v = Api.pixel_info_infer_space(this.ptr);
        return (ColorSpace)((Object)EnumUtil.fromValue(ColorSpace.class, v));
    }

    public ColorModel colorModel() {
        long cm = Api.pixel_info_color_model(this.ptr);
        return ColorModel.wrap(cm, false);
    }

    public boolean isRgbx() {
        return Api.pixel_info_is_rgbx(this.ptr);
    }

    public String toString() {
        return Api.pixel_info_stringfy(this.ptr);
    }
}

