/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.hmp;

import com.bytedance.hmp.Api;
import com.bytedance.hmp.Device;
import com.bytedance.hmp.DeviceType;
import com.bytedance.hmp.EnumUtil;
import com.bytedance.hmp.Ptr;
import com.bytedance.hmp.Scalar;
import com.bytedance.hmp.ScalarType;

public class Tensor
extends Ptr {
    public static Tensor wrap(long ptr, boolean own) {
        return new Tensor(ptr, own);
    }

    Tensor(long ptr_, boolean own_) {
        this.ptr = ptr_;
        this.own = own_;
    }

    public void free() {
        if (this.own) {
            Api.tensor_free(this.ptr);
        }
    }

    public String toString() {
        return Api.tensor_stringfy(this.ptr);
    }

    public void fill(long value) {
        Scalar v = new Scalar(value);
        Api.tensor_fill(this.ptr, v.getPtr());
        v.free();
    }

    public void fill(double value) {
        Scalar v = new Scalar(value);
        Api.tensor_fill(this.ptr, v.getPtr());
        v.free();
    }

    public void fill(boolean value) {
        Scalar v = new Scalar(value);
        Api.tensor_fill(this.ptr, v.getPtr());
        v.free();
    }

    public boolean defined() {
        return Api.tensor_defined(this.ptr);
    }

    public long dim() {
        return Api.tensor_dim(this.ptr);
    }

    public long size(long dim) {
        return Api.tensor_size(this.ptr, dim);
    }

    public long stride(long dim) {
        return Api.tensor_stride(this.ptr, dim);
    }

    public long nitems() {
        return Api.tensor_nitems(this.ptr);
    }

    public long itemsize() {
        return Api.tensor_itemsize(this.ptr);
    }

    public long nbytes() {
        return Api.tensor_nbytes(this.ptr);
    }

    public ScalarType dtype() {
        int v = Api.tensor_dtype(this.ptr);
        return (ScalarType)((Object)EnumUtil.fromValue(ScalarType.class, v));
    }

    public boolean isContiguous() {
        return Api.tensor_is_contiguous(this.ptr);
    }

    public DeviceType deviceType() {
        int v = Api.tensor_device_type(this.ptr);
        return (DeviceType)((Object)EnumUtil.fromValue(DeviceType.class, v));
    }

    public int deviceIndex() {
        return Api.tensor_device_index(this.ptr);
    }

    public long dataPtr() {
        return Api.tensor_data_ptr(this.ptr);
    }

    public Tensor clone() {
        long nptr = Api.tensor_clone(this.ptr);
        return Tensor.wrap(nptr, true);
    }

    public Tensor alias() {
        long nptr = Api.tensor_alias(this.ptr);
        return Tensor.wrap(nptr, true);
    }

    public Tensor view(long[] shape) {
        long nptr = Api.tensor_view(this.ptr, shape);
        return Tensor.wrap(nptr, true);
    }

    public Tensor reshape(long[] shape) {
        long nptr = Api.tensor_reshape(this.ptr, shape);
        return Tensor.wrap(nptr, true);
    }

    public Tensor slice(long dim, long start, long end, long step) {
        long nptr = Api.tensor_slice(this.ptr, dim, start, end, step);
        return Tensor.wrap(nptr, true);
    }

    public Tensor select(long dim, long index) {
        long nptr = Api.tensor_select(this.ptr, dim, index);
        return Tensor.wrap(nptr, true);
    }

    public Tensor permute(long[] dims) {
        long nptr = Api.tensor_permute(this.ptr, dims);
        return Tensor.wrap(nptr, true);
    }

    public Tensor squeeze(long dim) {
        long nptr = Api.tensor_squeeze(this.ptr, dim);
        return Tensor.wrap(nptr, true);
    }

    public Tensor unsqueeze(long dim) {
        long nptr = Api.tensor_unsqueeze(this.ptr, dim);
        return Tensor.wrap(nptr, true);
    }

    public Tensor to(String device, boolean nonBlocking) {
        long nptr = Api.tensor_to_device(this.ptr, device, nonBlocking);
        return Tensor.wrap(nptr, true);
    }

    public Tensor to(Device device, boolean nonBlocking) {
        return this.to(device.toString(), nonBlocking);
    }

    public Tensor to(ScalarType dtype) {
        long nptr = Api.tensor_to_dtype(this.ptr, dtype.getValue());
        return Tensor.wrap(nptr, true);
    }

    public void copyFrom(Tensor from) {
        Api.tensor_copy_from(this.ptr, from.getPtr());
    }

    public static Tensor empty(long[] shape, ScalarType dtype, String device, boolean pinned_memory) {
        long ptr = Api.tensor_empty(shape, dtype.getValue(), device, pinned_memory);
        return Tensor.wrap(ptr, true);
    }

    public static Tensor empty(long[] shape, ScalarType dtype, Device device, boolean pinned_memory) {
        return Tensor.empty(shape, dtype, device.toString(), pinned_memory);
    }

    public static Tensor arange(long start, long end, long step, ScalarType dtype, String device, boolean pinned_memory) {
        long ptr = Api.tensor_arange(start, end, step, dtype.getValue(), device, pinned_memory);
        return Tensor.wrap(ptr, true);
    }

    public static Tensor arange(long start, long end, long step, ScalarType dtype, Device device, boolean pinned_memory) {
        return Tensor.arange(start, end, step, dtype, device.toString(), pinned_memory);
    }

    public static Tensor fromFile(String fn, ScalarType dtype, long count, long offset) {
        long ptr = Api.tensor_from_file(fn, dtype.getValue(), count, offset);
        return Tensor.wrap(ptr, true);
    }

    public void toFile(String fn) {
        Api.tensor_to_file(this.ptr, fn);
    }
}

