/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.boringssl.so;

import android.util.Log;
import com.bytedance.boringssl.so.IBoringsslLoader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BoringsslLoaderWrapper {
    private static volatile boolean hasLoadBoringssl = false;
    private static volatile boolean hasLoadCrypto = false;
    private static volatile IBoringsslLoader iBoringsslLoader = null;
    private static volatile String DEFAULT_BORINGSSL_NAME = "ttboringssl";
    private static volatile String DEFAULT_CRYPTO_NAME = "ttcrypto";
    private static final String TAG = "BoringsslLoaderWrapper";
    private static Lock lock = new ReentrantLock();

    public static void setDefaultBoringsslName(String boringsslName) {
        DEFAULT_BORINGSSL_NAME = boringsslName;
    }

    public static void setDefaultCryptoName(String cryptoName) {
        DEFAULT_CRYPTO_NAME = cryptoName;
    }

    public static void setBoringsslLoader(IBoringsslLoader loader) {
        iBoringsslLoader = loader;
    }

    public static boolean loadBoringssl() {
        try {
            lock.lock();
            if (iBoringsslLoader != null) {
                boolean bl = iBoringsslLoader.loadBoringssl();
                return bl;
            }
            if (!hasLoadCrypto) {
                System.loadLibrary(DEFAULT_CRYPTO_NAME);
                hasLoadCrypto = true;
            }
            if (!hasLoadBoringssl) {
                System.loadLibrary(DEFAULT_BORINGSSL_NAME);
                hasLoadBoringssl = true;
            }
        }
        catch (Error e) {
            Log.e((String)TAG, (String)("load boringssl:" + hasLoadBoringssl + " load crypto:" + hasLoadCrypto + "  err:" + e.toString()));
        }
        finally {
            lock.unlock();
        }
        return hasLoadBoringssl && hasLoadCrypto;
    }
}

