/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.common;

import android.os.Build;
import android.os.Bundle;

public class Parameter {
    private Bundle mBundle;

    public Parameter() {
        this.mBundle = new Bundle();
    }

    private Parameter(Bundle bundle) {
        this.mBundle = bundle;
    }

    public void setInt(String key, int value) {
        this.mBundle.putInt(key, value);
    }

    public int getInt(String key, int defaultValue) {
        return this.containsKey(key) ? this.mBundle.getInt(key) : defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public void setLong(String key, long value) {
        this.mBundle.putLong(key, value);
    }

    public long getLong(String key, long defaultValue) {
        return this.containsKey(key) ? this.mBundle.getLong(key) : defaultValue;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public void setString(String key, String value) {
        this.mBundle.putString(key, value);
    }

    public void setBoolean(String key, boolean value) {
        this.mBundle.putBoolean(key, value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.containsKey(key) ? this.mBundle.getBoolean(key) : defaultValue;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public String getString(String key, String defaultValue) {
        return this.containsKey(key) ? this.mBundle.getString(key) : defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public void setFloat(String key, float value) {
        this.mBundle.putFloat(key, value);
    }

    public float getFloat(String key, float defaultValue) {
        return this.containsKey(key) ? this.mBundle.getFloat(key) : defaultValue;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public void setDouble(String key, double value) {
        this.mBundle.putDouble(key, value);
    }

    public double getDouble(String key, float defaultValue) {
        return this.containsKey(key) ? this.mBundle.getDouble(key) : (double)defaultValue;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0f);
    }

    public boolean containsKey(String key) {
        return this.mBundle.containsKey(key);
    }

    public void setParameter(String key, Parameter value) {
        this.mBundle.putBundle(key, value.mBundle);
    }

    public Parameter getParameter(String key, Parameter p) {
        Bundle bundle = this.mBundle.getBundle(key);
        if (bundle == null) {
            return p;
        }
        return new Parameter(bundle);
    }

    public Parameter getParameter(String key) {
        return this.getParameter(key, null);
    }

    public void reset() {
        this.mBundle.clear();
    }

    public void copyTo(Parameter p) {
        p.mBundle = Build.VERSION.SDK_INT >= 26 ? this.mBundle.deepCopy() : (Bundle)this.mBundle.clone();
    }

    public String toString() {
        return this.mBundle.toString();
    }
}

