/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.common.env;

import android.content.Context;
import android.text.TextUtils;
import com.pandora.common.applog.IAppLogEngine;
import com.pandora.common.globalsettings.FetchSettingsManager;
import com.pandora.common.settings.TTVideoSettingManager;
import com.pandora.common.utils.TTVideoLog;

public class Env {
    private static Env sEnv;
    private SdkContextEnv mSdkContextEnv;
    private static IAppLogEngine mAppLogClient;

    private Env() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Env get() {
        Class<Env> clazz = Env.class;
        synchronized (Env.class) {
            if (sEnv == null) {
                sEnv = new Env();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sEnv;
        }
    }

    public static Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return Env.get().mSdkContextEnv.getUncaughtExceptionHandler();
    }

    public static void setupSDKEnv(SdkContextEnv sdkContextEnv) {
        Env.get().mSdkContextEnv = sdkContextEnv;
        TTVideoSettingManager.initSettings();
        FetchSettingsManager.getInstance().fetchSdkParams();
    }

    public static void setAppLogClient(IAppLogEngine logClient) {
        mAppLogClient = logClient;
    }

    public static IAppLogEngine getAppLogClient() {
        return mAppLogClient;
    }

    public static void openDebugLog(boolean enable) {
        TTVideoLog.turnOn(1, enable ? 1 : 0);
    }

    public static Context getApplicationContext() {
        return Env.get().mSdkContextEnv.getApplicationContext();
    }

    private static Object getTTSDKFieldValue(String fieldName) {
        try {
            Class<?> b = Class.forName("com.pandora.ttsdk.BuildConfig");
            return b.getField(fieldName).get(b);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getVersion() {
        return "1.13.1.2101";
    }

    public static String getBuildType() {
        return "release";
    }

    public static String getFlavor() {
        String flavor = (String)Env.getTTSDKFieldValue("FLAVOR");
        if (TextUtils.isEmpty((CharSequence)flavor)) {
            flavor = "unknown";
        }
        return flavor;
    }

    public static int getVersionCode() {
        return 1803;
    }

    public static String getAppID() {
        return Env.get().mSdkContextEnv.getAppID();
    }

    public static String getAppName() {
        return Env.get().mSdkContextEnv.getAppName();
    }

    public static String getAppRegion() {
        return Env.get().mSdkContextEnv.getAppRegion();
    }

    public static String getLicenseDir() {
        return Env.get().mSdkContextEnv.getLicenseDir();
    }

    public static String getLicenseFileName() {
        return Env.get().mSdkContextEnv.getLicenseFileName();
    }

    public static SdkContextEnv getEnv() {
        return Env.get().mSdkContextEnv;
    }

    public static interface SdkContextEnv {
        public Context getApplicationContext();

        public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler();

        public String getAppID();

        public String getAppName();

        public String getAppRegion();

        public String getLicenseDir();

        public String getLicenseFileName();
    }
}

