/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.common.globalsettings;

import android.text.TextUtils;
import android.util.Log;
import com.pandora.common.globalsettings.GlobalSdkParams;
import com.pandora.common.globalsettings.GlobalSdkParamsUtil;
import com.pandora.common.utils.TTVideoLog;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchSettingsManager {
    private static final String TAG = "FetchSettingsManager";
    private boolean enableSettingsUpdate = true;

    private FetchSettingsManager() {
    }

    public static FetchSettingsManager getInstance() {
        return FetchGlobalSdkParamsManagerHolder.INSTANCE;
    }

    public void setEnableSettingsUpdate(boolean enable) {
        this.enableSettingsUpdate = enable;
    }

    public boolean isEnableSettingsUpdate() {
        return this.enableSettingsUpdate;
    }

    public void fetchSdkParams() {
        if (!this.enableSettingsUpdate) {
            Log.i((String)TAG, (String)"Ignore fetch sdk parames");
            return;
        }
        final String url = GlobalSdkParamsUtil.settingURLString("https://stream.snssdk.com");
        new Thread(new Runnable(){

            @Override
            public void run() {
                String response = GlobalSdkParamsUtil.get(url);
                if (!TextUtils.isEmpty((CharSequence)response)) {
                    try {
                        JSONObject responseJson = new JSONObject(response);
                        if (!responseJson.has("Result")) {
                            String error = responseJson.getJSONObject("ResponseMetadata").getJSONObject("Error").toString();
                            Log.e((String)"GlobalSdkParamsUtil", (String)"result is not exist");
                            TTVideoLog.d("GlobalSdkParamsUtil", "url=" + url + " error msg=" + error);
                            FetchSettingsManager.this.delayFetchSetting();
                            return;
                        }
                        JSONObject resultObject = (JSONObject)responseJson.get("Result");
                        if (resultObject == null) {
                            Log.e((String)"GlobalSdkParamsUtil", (String)"resultObject is null");
                            FetchSettingsManager.this.delayFetchSetting();
                            return;
                        }
                        if (!GlobalSdkParams.getInstance().setSettings(resultObject)) {
                            FetchSettingsManager.this.delayFetchSetting();
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        FetchSettingsManager.this.delayFetchSetting();
                    }
                } else {
                    Log.e((String)"GlobalSdkParamsUtil", (String)"response is null or empty");
                    FetchSettingsManager.this.delayFetchSetting();
                }
            }
        }).start();
    }

    private void delayFetchSetting() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                FetchSettingsManager.this.fetchSdkParams();
            }
        }, 5000L);
    }

    private static class FetchGlobalSdkParamsManagerHolder {
        private static final FetchSettingsManager INSTANCE = new FetchSettingsManager();

        private FetchGlobalSdkParamsManagerHolder() {
        }
    }
}

