/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.common.settings;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.bytedance.ttvideosetting.TTVideoFetchSettingManager;
import com.bytedance.ttvideosetting.TTVideoSettingListener;
import com.bytedance.ttvideosetting.TTVideoSettingsManager;
import com.pandora.common.applog.IApplogObserver;
import com.pandora.common.env.Env;
import com.pandora.common.settings.ISettingsListener;
import com.pandora.common.settings.ModuleInfo;
import com.pandora.common.utils.TTVideoLog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class TTVideoSettingManager
implements TTVideoSettingListener {
    private static TTVideoSettingManager instance;
    private TTVideoSettingsManager settingsManager;
    private TTVideoFetchSettingManager fetchSettingManager;
    private Context mContext;
    private static String TAG;
    private static ArrayList<ISettingsListener> mListenerList;
    private static JSONObject mSettingsJson;

    public static void initSettings() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                TTVideoSettingManager._tryInitSettings(Env.getApplicationContext());
            }
        }, 3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ISettingsListener listener) {
        Class<TTVideoSettingManager> clazz = TTVideoSettingManager.class;
        synchronized (TTVideoSettingManager.class) {
            if (mSettingsJson != null) {
                listener.onUpdated(mSettingsJson);
            }
            if (mListenerList != null && !mListenerList.contains(listener)) {
                mListenerList.add(listener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static JSONObject getSettingsJson() {
        return mSettingsJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void oNotify(int what) {
        switch (what) {
            case 0: {
                Class<TTVideoSettingManager> clazz = TTVideoSettingManager.class;
                synchronized (TTVideoSettingManager.class) {
                    mSettingsJson = this.settingsManager.mSettingJson;
                    if (mSettingsJson == null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    TTVideoLog.d(TAG, "settings update json:" + mSettingsJson.toString());
                    if (mListenerList == null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    for (ISettingsListener listener : mListenerList) {
                        listener.onUpdated(mSettingsJson);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    public static void startFetchSettingisForce(boolean isForce) {
        if (instance != null) {
            TTVideoSettingManager.instance.fetchSettingManager.setDebug(false);
            TTVideoSettingManager.instance.fetchSettingManager.fetchSettingInfoisForce(isForce);
        }
    }

    public static synchronized boolean isInitialized() {
        return instance != null;
    }

    public static synchronized TTVideoSettingManager getInstance(Context context) {
        if (instance == null) {
            instance = new TTVideoSettingManager(context);
        }
        return instance;
    }

    private TTVideoSettingManager(Context context) {
        this.mContext = context;
        this.fetchSettingManager = TTVideoFetchSettingManager.getInstance((Context)this.mContext);
        TTVideoFetchSettingManager.setSettingHost((String)"vas-hl-x.snssdk.com");
        try {
            this.settingsManager = TTVideoSettingsManager.getInstance((Context)this.mContext);
            this.settingsManager.setIsSaveLocal(false);
            this.settingsManager.addListener((TTVideoSettingListener)this);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void _tryInitSettings(final Context context) {
        if (Env.getAppLogClient() == null) {
            TTVideoSettingManager._initSettingsInternal(context);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)Env.getAppLogClient().getDeviceID())) {
            Env.getAppLogClient().addDataObserver(new IApplogObserver(){

                @Override
                public void onDataLoaded(Map idMap) {
                    TTVideoLog.d(TAG, "did callback:" + (idMap != null ? idMap.get("did") : ""));
                    TTVideoSettingManager._initSettingsInternal(context);
                }
            });
        } else {
            TTVideoSettingManager._initSettingsInternal(context);
        }
    }

    private static void _initSettingsInternal(Context context) {
        TTVideoSettingManager.getInstance(context);
        TTVideoSettingManager.setSettingConfig();
        TTVideoSettingManager.startFetchSettingisForce(true);
    }

    private static void setSettingConfig() {
        String did;
        if (instance == null) {
            return;
        }
        HashMap<String, Object> getPara = new HashMap<String, Object>();
        getPara.put("aid", Long.parseLong(Env.getAppID()));
        getPara.put("app_name", Env.getAppName());
        if (Env.getAppLogClient() != null && !TextUtils.isEmpty((CharSequence)(did = Env.getAppLogClient().getDeviceID()))) {
            getPara.put("device_id", did);
        }
        if (Env.getAppRegion() != null) {
            if (Env.getAppRegion().equals("china")) {
                getPara.put("region", "cn-north-1");
            } else if (Env.getAppRegion().equals("amercia")) {
                getPara.put("region", "us-east-1");
            }
        }
        for (ModuleInfo.Info info : ModuleInfo.mModuleInfos) {
            try {
                Class<?> buildConfigCls = Class.forName(info.iPackageInfo + "." + info.iVersionFile);
                Field field = buildConfigCls.getField("VERSION_NAME");
                field.setAccessible(true);
                String version = (String)field.get(null);
                if (TextUtils.isEmpty((CharSequence)version)) continue;
                getPara.put(info.iSettingQuery, TTVideoSettingManager.versionStringToInt(version));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        instance.loadFetchConfig(getPara);
    }

    private void loadFetchConfig(Map<String, Object> config) {
        HashMap<String, Map<String, Object>> fetchConfig = new HashMap<String, Map<String, Object>>();
        fetchConfig.put(TTVideoFetchSettingManager.TTVideoSettingFetchQuery, config);
        this.fetchSettingManager.loadFetchConfig(fetchConfig);
    }

    private static int versionStringToInt(String version) {
        if (version == null || version.isEmpty()) {
            return 0;
        }
        String[] versionArray = version.split("\\.");
        if (versionArray.length <= 0) {
            return 0;
        }
        int versionCode = 0;
        for (int i = 0; i < versionArray.length; ++i) {
            int result = 0;
            if (i == 0) {
                versionCode = Integer.parseInt(versionArray[i]);
                continue;
            }
            result = Integer.parseInt(versionArray[i]);
            versionCode = versionCode * 100 + result;
        }
        return versionCode;
    }

    static {
        TAG = "TTVideoSettingManager";
        mListenerList = new ArrayList();
        mSettingsJson = null;
    }
}

