/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttvideosetting;

import android.content.Context;
import android.util.Log;
import com.bytedance.ttvideosetting.TTVideoSettingsManager;
import com.bytedance.ttvideosetting.TTVideoSettingsUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;

public class TTVideoFetchSettingManager {
    public static String TTVideofetchSettingTime = "TTVideofetchSettingTime";
    public static String TTVideoSettingFetchQuery = "TTVideoSettingFetchQuery";
    private HashMap<String, Object> configParameter;
    private int fetchVideoRetyTimes = 0;
    private Context mContext;
    private static TTVideoFetchSettingManager instance;
    private boolean isOpenDebug = false;
    private static String TTVideoSettingConfigKey;
    private static String TTVideoSettingFetchIntervalKey;
    private static String SettingHost;

    public static synchronized TTVideoFetchSettingManager getInstance(Context context) {
        if (instance == null) {
            instance = new TTVideoFetchSettingManager(context);
        }
        return instance;
    }

    private TTVideoFetchSettingManager(Context context) {
        this.mContext = context;
    }

    public void loadFetchConfig(HashMap<String, Object> config) {
        this.configParameter = config;
    }

    public void fetchSettingInfoisForce(boolean isForce) {
        this.fetchVideoRetyTimes = 0;
        if (isForce) {
            this.startFetchSettingInfo();
        } else {
            this.fetchSettingInfoIfNeeded();
        }
    }

    public void setDebug(boolean isOpen) {
        this.isOpenDebug = isOpen;
    }

    private void fetchSettingInfoIfNeeded() {
        long currentTime = System.currentTimeMillis();
        long lastTime = TTVideoSettingsUtil.getLong(this.mContext.getApplicationContext(), TTVideofetchSettingTime, 0L);
        long duration = 86400L;
        try {
            JSONObject durationObject;
            TTVideoSettingsManager manager = TTVideoSettingsManager.getInstance(this.mContext);
            String config = TTVideoSettingsUtil.getString(this.mContext.getApplicationContext(), TTVideoSettingConfigKey);
            if (config != null && !config.isEmpty() && (durationObject = new JSONObject(config)) != null && !durationObject.isNull(TTVideoSettingFetchIntervalKey)) {
                duration = durationObject.getLong(TTVideoSettingFetchIntervalKey);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (duration < 0L) {
            duration = 86400L;
        }
        if (currentTime - lastTime > duration * 1000L) {
            this.startFetchSettingInfo();
        }
    }

    public static void setSettingHost(String host) {
        SettingHost = host;
    }

    private void startFetchSettingInfo() {
        Object parameter;
        if (this.fetchVideoRetyTimes > 10) {
            this.fetchVideoRetyTimes = 0;
            return;
        }
        ++this.fetchVideoRetyTimes;
        HashMap getPara = new HashMap();
        if (this.configParameter != null && !this.configParameter.isEmpty() && (parameter = this.configParameter.get(TTVideoSettingFetchQuery)) != null && parameter instanceof Map) {
            getPara = (HashMap)parameter;
        }
        if (SettingHost == null || SettingHost.length() == 0) {
            Log.e((String)TTVideoSettingsUtil.TAG, (String)"SettingHost is null,will return");
            return;
        }
        String host = "https://" + SettingHost;
        getPara.put("caller_name", TTVideoSettingsUtil.getCallerName());
        getPara.put("device_platform", "android");
        getPara.put("os_version", TTVideoSettingsUtil.getSystemVersion());
        getPara.put("os_api", TTVideoSettingsUtil.getSystemAPI());
        getPara.put("app", 1);
        if (getPara.get("device_brand") == null) {
            getPara.put("device_brand", TTVideoSettingsUtil.getDeviceBrand());
        }
        if (getPara.get("device_type") == null) {
            getPara.put("device_type", TTVideoSettingsUtil.getDeviceModel().toLowerCase());
        }
        if (this.isOpenDebug) {
            getPara.put("debug", 1);
        }
        final HashMap finalGetPara = getPara;
        final String finalHost = host;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Set set = finalGetPara.entrySet();
                Iterator iterator = set.iterator();
                String uri = "?";
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    uri = uri + mapEntry.getKey() + "=" + mapEntry.getValue() + "&";
                }
                String respone = TTVideoSettingsUtil.get(String.format("%s/service/settings/v2/", finalHost) + uri);
                if (respone == null || respone.isEmpty()) {
                    Log.e((String)TTVideoSettingsUtil.TAG, (String)"respone is null or empty");
                    TTVideoFetchSettingManager.this.delayFetchSetting();
                    return;
                }
                TTVideoSettingsUtil.putLong(TTVideoFetchSettingManager.this.mContext.getApplicationContext(), TTVideofetchSettingTime, System.currentTimeMillis());
                try {
                    JSONObject dataObject;
                    JSONObject responeJson = new JSONObject(respone);
                    if (responeJson == null) {
                        Log.e((String)TTVideoSettingsUtil.TAG, (String)"responeJson is null");
                        TTVideoFetchSettingManager.this.delayFetchSetting();
                        return;
                    }
                    if (TTVideoFetchSettingManager.this.isOpenDebug) {
                        TTVideoSettingsUtil.v(TTVideoSettingsUtil.TAG, "videoSetting respone" + respone);
                    }
                    if ((dataObject = (JSONObject)responeJson.get("data")) == null || dataObject.isNull("app")) {
                        Log.e((String)TTVideoSettingsUtil.TAG, (String)"dataObject is null");
                        TTVideoFetchSettingManager.this.delayFetchSetting();
                        return;
                    }
                    JSONObject appObject = dataObject.getJSONObject("app");
                    if (appObject == null) {
                        Log.e((String)TTVideoSettingsUtil.TAG, (String)"appSetting is null");
                        TTVideoFetchSettingManager.this.delayFetchSetting();
                        return;
                    }
                    TTVideoSettingsManager manager = TTVideoSettingsManager.getInstance(TTVideoFetchSettingManager.this.mContext);
                    if (!appObject.isNull(TTVideoSettingConfigKey)) {
                        JSONObject settingConfig = appObject.getJSONObject(TTVideoSettingConfigKey);
                        TTVideoSettingsUtil.putString(TTVideoFetchSettingManager.this.mContext, TTVideoSettingConfigKey, settingConfig.toString());
                    }
                    manager.saveSettingJson(appObject);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void delayFetchSetting() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                TTVideoFetchSettingManager.this.startFetchSettingInfo();
            }
        }, 5000L);
    }

    static {
        TTVideoSettingConfigKey = "setting_config";
        TTVideoSettingFetchIntervalKey = "fetchSettingInterval";
        SettingHost = "";
    }
}

