/*
 * Decompiled with CFR 0.152.
 */
package com.ss.lens.algorithm;

public class VideoOCLSR {
    private long mNativePtr = 0L;
    private static boolean isLibLoaded = false;

    public synchronized boolean InitVideoOclSr(String kernelBinPath, int algType, boolean isExtOESTexture) {
        if (!isLibLoaded) {
            try {
                System.loadLibrary("c++_shared");
                System.loadLibrary("bytenn");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.loadLibrary("lens");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                return false;
            }
            isLibLoaded = true;
        }
        if (kernelBinPath.isEmpty()) {
            return false;
        }
        this.mNativePtr = this.nativeInitVideoOclSr(kernelBinPath, algType, isExtOESTexture, true, 720, 1440);
        return this.mNativePtr != 0L;
    }

    public synchronized boolean InitVideoOclSr(String kernelBinPath, int algType, boolean isExtOESTexture, int maxHeight, int maxWidth) {
        if (!isLibLoaded) {
            try {
                System.loadLibrary("c++_shared");
                System.loadLibrary("bytenn");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.loadLibrary("lens");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                return false;
            }
            isLibLoaded = true;
        }
        if (kernelBinPath.isEmpty()) {
            return false;
        }
        this.mNativePtr = this.nativeInitVideoOclSr(kernelBinPath, algType, isExtOESTexture, true, maxHeight, maxWidth);
        return this.mNativePtr != 0L;
    }

    public synchronized boolean InitVideoOclSr(String kernelBinPath, int algType, boolean isExtOESTexture, boolean isMaliSync, int maxHeight, int maxWidth) {
        if (!isLibLoaded) {
            try {
                System.loadLibrary("c++_shared");
                System.loadLibrary("bytenn");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.loadLibrary("lens");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                return false;
            }
            isLibLoaded = true;
        }
        if (kernelBinPath.isEmpty()) {
            return false;
        }
        this.mNativePtr = this.nativeInitVideoOclSr(kernelBinPath, algType, isExtOESTexture, isMaliSync, maxHeight, maxWidth);
        return this.mNativePtr != 0L;
    }

    public synchronized boolean InitVideoOclSrWithLicense(String kernelBinPath, int algType, boolean isExtOESTexture, boolean isMaliSync, String moduleName, int maxHeight, int maxWidth) {
        if (!isLibLoaded) {
            try {
                System.loadLibrary("c++_shared");
                System.loadLibrary("bytenn");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.loadLibrary("ttlicense2");
                System.loadLibrary("lens");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                return false;
            }
            isLibLoaded = true;
        }
        if (kernelBinPath.isEmpty()) {
            return false;
        }
        this.mNativePtr = this.nativeInitVideoOclSrWithLicense(kernelBinPath, algType, isExtOESTexture, isMaliSync, moduleName, maxHeight, maxWidth);
        return this.mNativePtr != 0L;
    }

    public int VideoOclSrOesProcess(int textureId, int width, int height, float[] stMatrix, boolean open) {
        if (this.mNativePtr == 0L || width <= 0 || height <= 0) {
            return -1;
        }
        return this.nativeVideoOclSrOesProcess(this.mNativePtr, textureId, width, height, stMatrix, open);
    }

    public int VideoOclSrProcess(int textureId, int width, int height, boolean open) {
        if (this.mNativePtr == 0L || width <= 0 || height <= 0) {
            return -1;
        }
        return this.nativeVideoOclSrProcess(this.mNativePtr, textureId, width, height, open);
    }

    public int GetVideoOclSrOutput() {
        if (this.mNativePtr == 0L) {
            return -1;
        }
        return this.nativeGetVideoOclSrOutput(this.mNativePtr);
    }

    public void ReleaseVideoOclSr() {
        if (this.mNativePtr == 0L) {
            return;
        }
        this.nativeReleaseVideoOclSr(this.mNativePtr);
    }

    private native long nativeInitVideoOclSrWithLicense(String var1, int var2, boolean var3, boolean var4, String var5, int var6, int var7);

    private native long nativeInitVideoOclSr(String var1, int var2, boolean var3, boolean var4, int var5, int var6);

    private native int nativeVideoOclSrOesProcess(long var1, int var3, int var4, int var5, float[] var6, boolean var7);

    private native int nativeVideoOclSrProcess(long var1, int var3, int var4, int var5, boolean var6);

    private native int nativeGetVideoOclSrOutput(long var1);

    private native void nativeReleaseVideoOclSr(long var1);
}

