/*
 * Decompiled with CFR 0.152.
 */
package com.ss.lens.algorithm;

import android.graphics.Bitmap;
import android.util.Log;

public class PictureOCLSR {
    private long mNativePtr = 0L;
    private static boolean isLibLoaded = false;
    private int maxHeight = 1080;
    private int minHeight = 500;
    private int maxWidth = 600;
    private int minWidth = 360;

    public synchronized boolean InitPictureOclSr(String kernelBinPath) {
        if (!isLibLoaded) {
            try {
                System.loadLibrary("c++_shared");
                System.loadLibrary("bytenn");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.loadLibrary("lens");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                return false;
            }
            isLibLoaded = true;
        }
        if (kernelBinPath.isEmpty()) {
            return false;
        }
        this.mNativePtr = this.nativeInitPictureOclSr(kernelBinPath, this.maxHeight, this.maxWidth, 4);
        return this.mNativePtr != 0L;
    }

    public synchronized boolean InitPictureOclSr(String kernelBinPath, int powerLevel) {
        if (!isLibLoaded) {
            try {
                System.loadLibrary("c++_shared");
                System.loadLibrary("bytenn");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.loadLibrary("lens");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                return false;
            }
            isLibLoaded = true;
        }
        if (kernelBinPath.isEmpty()) {
            return false;
        }
        this.mNativePtr = this.nativeInitPictureOclSr(kernelBinPath, this.maxHeight, this.maxWidth, powerLevel);
        return this.mNativePtr != 0L;
    }

    public synchronized boolean InitPictureOclSr(String kernelBinPath, int powerLevel, int minW, int maxW, int minH, int maxH) {
        if (minW > maxW || minH > maxH || minW <= 0 || minH <= 0) {
            return false;
        }
        if (!isLibLoaded) {
            try {
                System.loadLibrary("c++_shared");
                System.loadLibrary("bytenn");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            try {
                System.loadLibrary("lens");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                return false;
            }
            isLibLoaded = true;
        }
        this.maxHeight = maxH;
        this.minHeight = minH;
        this.maxWidth = maxW;
        this.minWidth = minW;
        if (kernelBinPath.isEmpty()) {
            return false;
        }
        this.mNativePtr = this.nativeInitPictureOclSr(kernelBinPath, this.maxHeight, this.maxWidth, powerLevel);
        return this.mNativePtr != 0L;
    }

    public boolean IsSrSupport(Bitmap srcBitmap) {
        if (srcBitmap.getConfig() != Bitmap.Config.RGB_565) {
            Log.d((String)"vrsr_picture", (String)"sr is not supported because input picture format is not support, only support format rgb_565");
            return false;
        }
        int width = srcBitmap.getWidth();
        int height = srcBitmap.getHeight();
        if (width % 2 != 0 || height % 2 != 0) {
            Log.d((String)"vrsr_picture", (String)("sr is not supported because input size h " + height + " w " + width + " is not support"));
            return false;
        }
        if (width < this.minWidth || width > this.maxWidth || height < this.minHeight || height > this.maxHeight) {
            Log.d((String)"vrsr_picture", (String)("sr is not supported because input size h " + height + " w " + width + " is not support"));
            return false;
        }
        return true;
    }

    public synchronized int PictureOclSrProcess(Bitmap srcBitmap, Bitmap dstBitmap) {
        int width = srcBitmap.getWidth();
        int height = srcBitmap.getHeight();
        if (width % 2 != 0 || height % 2 != 0) {
            Log.d((String)"vrsr_picture", (String)("sr process failed because input size h " + height + " w " + width + " is not support"));
            return -1;
        }
        if (width < this.minWidth || width > this.maxWidth || height < this.minHeight || height > this.maxHeight) {
            Log.d((String)"vrsr_picture", (String)("sr is not supported because input size h " + height + " w " + width + " is not support"));
            return -1;
        }
        int res = this.nativePictureOclSrProcess(this.mNativePtr, srcBitmap, dstBitmap);
        if (res != 0) {
            Log.d((String)"vrsr_picture", (String)("sr process failed with error code " + Integer.valueOf(res).toString()));
            return -1;
        }
        return 0;
    }

    public void ReleasePictureOclSr() {
        if (this.mNativePtr == 0L) {
            return;
        }
        this.nativeReleasePictureOclSr(this.mNativePtr);
    }

    private native long nativeInitPictureOclSr(String var1, int var2, int var3, int var4);

    private native int nativePictureOclSrProcess(long var1, Bitmap var3, Bitmap var4);

    private native void nativeReleasePictureOclSr(long var1);
}

