/*
 * Decompiled with CFR 0.152.
 */
package com.ss.lens.algorithm;

public class VideoVFI {
    private long mNativePtr = 0L;
    private static boolean isLibLoaded = false;

    public synchronized boolean InitVideoVFI(String kernelBinPath, int algType, int powerLevel, int inputFrameNum, boolean isExtOESTexture) {
        if (!isLibLoaded) {
            try {
                System.loadLibrary("lens");
                System.loadLibrary("bytenn");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                return false;
            }
            try {
                System.loadLibrary("lens");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                return false;
            }
            isLibLoaded = true;
        }
        if (kernelBinPath.isEmpty()) {
            return false;
        }
        this.mNativePtr = this.nativeInitVideoVFI(kernelBinPath, algType, powerLevel, inputFrameNum, isExtOESTexture);
        return this.mNativePtr != 0L;
    }

    public int VideoVFIOesProcess(int textureIdP, int textureIdN, int width, int height, int flag, float timeStamp, float[] stMatrix, boolean open) {
        if (this.mNativePtr == 0L || width <= 0 || height <= 0) {
            return -1;
        }
        return this.nativeVideoVFIOesProcess(this.mNativePtr, textureIdP, textureIdN, width, height, flag, timeStamp, stMatrix, open);
    }

    public int VideoVFIProcess(int textureIdP, int textureIdN, int width, int height, int flag, float timeStamp, boolean open) {
        if (this.mNativePtr == 0L || width <= 0 || height <= 0) {
            return -1;
        }
        return this.nativeVideoVFIProcess(this.mNativePtr, textureIdP, textureIdN, width, height, flag, timeStamp, open);
    }

    public int GetVideoVFIOutput() {
        if (this.mNativePtr == 0L) {
            return -1;
        }
        return this.nativeGetVideoVFIOutput(this.mNativePtr);
    }

    public void ReleaseVideoVFI() {
        if (this.mNativePtr == 0L) {
            return;
        }
        this.nativeReleaseVideoVFI(this.mNativePtr);
    }

    private native long nativeInitVideoVFI(String var1, int var2, int var3, int var4, boolean var5);

    private native int nativeVideoVFIOesProcess(long var1, int var3, int var4, int var5, int var6, int var7, float var8, float[] var9, boolean var10);

    private native int nativeVideoVFIProcess(long var1, int var3, int var4, int var5, int var6, int var7, float var8, boolean var9);

    private native int nativeGetVideoVFIOutput(long var1);

    private native void nativeReleaseVideoVFI(long var1);
}

