/*
 * Decompiled with CFR 0.152.
 */
package com.ss.videoarch.strategy.network;

import android.text.TextUtils;
import android.util.Pair;
import com.ss.videoarch.strategy.network.IHttpExecutor;
import com.ss.videoarch.strategy.network.LSSDKConfig;
import com.ss.videoarch.strategy.network.model.HttpResponseException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.json.JSONObject;

public class HttpApi {
    private final String apiHost;
    private final IHttpExecutor executor;
    private final List<Pair<String, String>> commonParams;

    HttpApi(LSSDKConfig config) {
        this.apiHost = config.mApiHost;
        this.executor = config.mHttpExecutor;
        this.commonParams = config.mCommonParams;
    }

    public JSONObject getJson(String urlPath) throws Exception {
        JSONObject response = this.doGetJson(urlPath);
        return response;
    }

    public JSONObject postJson(String urlPath, Object object) throws Exception {
        JSONObject response = this.doPostJson(urlPath, object);
        return response;
    }

    private JSONObject handleGetResponse(JSONObject response) throws Exception {
        if (response == null) {
            throw new HttpResponseException(0);
        }
        return response.getJSONObject("Result");
    }

    private JSONObject handlePostResponse(JSONObject response) throws Exception {
        if (response == null) {
            throw new HttpResponseException(0);
        }
        return response.getJSONObject("Result");
    }

    private JSONObject doGetJson(String urlPath) throws Exception {
        String requestUrl = HttpApi.addParams(this.apiHost + urlPath, this.commonParams);
        String responseStr = this.executor.executeGet(requestUrl);
        JSONObject response = new JSONObject(responseStr);
        return response;
    }

    private JSONObject doPostJson(String urlPath, Object object) throws Exception {
        String requestUrl = HttpApi.addParams(this.apiHost + urlPath, this.commonParams);
        String requestStr = object.toString();
        String responseStr = this.executor.executePost(requestUrl, requestStr.getBytes("UTF-8"), "gzip", "application/json; charset=utf-8");
        JSONObject response = new JSONObject(responseStr);
        return response;
    }

    private static String addParams(String url, List<Pair<String, String>> params) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        if (url.indexOf(63) < 0) {
            if (params.size() > 0) {
                sb.append("?");
            }
        } else {
            sb.append("&");
        }
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                sb.append("&");
            }
            Pair<String, String> pair = params.get(i);
            sb.append((String)pair.first).append('=').append(HttpApi.encode((String)pair.second, "UTF-8"));
        }
        return sb.toString();
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding);
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }
}

