/*
 * Decompiled with CFR 0.152.
 */
package com.ss.videoarch.strategy.network;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolApi {
    private final ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NetWorkThreadFactory());

    public void execute(Runnable task) {
        this.threadPool.execute(task);
    }

    private static class NetWorkThreadFactory
    implements ThreadFactory {
        private final ThreadGroup mThreadGroup;
        private final AtomicInteger mThreadNumber = new AtomicInteger(1);
        private final String mPrefix;

        private NetWorkThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.mThreadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.mPrefix = "live-strategy-network-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(this.mThreadGroup, r, this.mPrefix + this.mThreadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

