/*
 * Decompiled with CFR 0.152.
 */
package com.ss.videoarch.strategy.network;

import android.util.Log;
import com.ss.videoarch.strategy.network.HttpApi;
import com.ss.videoarch.strategy.network.LSSDKConfig;
import com.ss.videoarch.strategy.utils.CalledByNative;
import com.ss.videoarch.strategy.utils.JNINamespace;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

@JNINamespace(value="jni")
public class VeLSNetworkManagerImpl {
    static String TAG = "SettingsManager";
    private HttpApi mHttpApi;
    private ExecutorService mExecutor = null;
    private int SEND_REQUEST_TIMEOUT = 10;

    public void init(LSSDKConfig config) {
        this.mHttpApi = new HttpApi(config);
        this.mExecutor = new ThreadPoolExecutor(1, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory(){});
    }

    @CalledByNative
    public String SendRequest(final String url, final String requestBody) {
        final String[] response = new String[]{""};
        Future<String> future = this.mExecutor.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                response[0] = VeLSNetworkManagerImpl.this.sendRequestByPost(url, requestBody);
                return response[0];
            }
        });
        try {
            future.get(this.SEND_REQUEST_TIMEOUT, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response[0];
    }

    private String sendRequestByPost(String url, String requestBody) {
        Log.d((String)TAG, (String)("sendRequestByPost: " + url));
        String responseStr = "";
        try {
            JSONObject jsonBody = new JSONObject(requestBody);
            JSONObject response = this.mHttpApi.postJson(url, jsonBody);
            responseStr = response.toString();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Exception:" + e.toString()));
        }
        return responseStr;
    }

    @CalledByNative
    public String SendRequest(final String url) {
        final String[] response = new String[]{""};
        Future<String> future = this.mExecutor.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                response[0] = VeLSNetworkManagerImpl.this.sendRequestByGet(url);
                return response[0];
            }
        });
        try {
            future.get(this.SEND_REQUEST_TIMEOUT, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response[0];
    }

    private String sendRequestByGet(String url) {
        Log.d((String)TAG, (String)("sendRequestByGet: " + url));
        String responseStr = "";
        try {
            JSONObject response = this.mHttpApi.getJson(url);
            responseStr = response.toString();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Exception:" + e.toString()));
        }
        return responseStr;
    }

    @CalledByNative
    public static VeLSNetworkManagerImpl getInstance() {
        return Inner.instance;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private NamedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "VeLSNetworkManager");
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 1) {
                thread.setPriority(1);
            }
            return thread;
        }
    }

    private static class Inner {
        private static final VeLSNetworkManagerImpl instance = new VeLSNetworkManagerImpl();

        private Inner() {
        }
    }
}

