/*
 * Decompiled with CFR 0.152.
 */
package com.ss.videoarch.strategy;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.ss.videoarch.strategy.IAppInfoBundle;
import com.ss.videoarch.strategy.IFunctionCalledByStrategyEngine;
import com.ss.videoarch.strategy.IFunctionStartPTYInit;
import com.ss.videoarch.strategy.ILiveStrategyCenter;
import com.ss.videoarch.strategy.dataCenter.strategyData.DataWarehouse;
import com.ss.videoarch.strategy.utils.LibraryLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;

public class LiveStrategyManager
implements ILiveStrategyCenter {
    static final String TAG = "VeLiveStrategyManager";
    private boolean mIsRunning = false;
    private static boolean mLoadSoSuccess = false;
    private static List<String> mLibraryList;
    public boolean mFirstStart = true;
    public static long mLoadLibraryTime;
    public Context mContext;
    private static volatile LiveStrategyManager sInstance;

    private static boolean loadLibrary(String name) {
        try {
            LibraryLoader.loadLibrary(name);
            Log.d((String)TAG, (String)("load library: " + name + ".so success"));
            return true;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("load library: " + name + ".so fail! " + e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LiveStrategyManager inst() {
        if (sInstance != null) return sInstance;
        Class<LiveStrategyManager> clazz = LiveStrategyManager.class;
        synchronized (LiveStrategyManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new LiveStrategyManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @Override
    @Nullable
    public void start() {
        if (this.mIsRunning) {
            Log.w((String)TAG, (String)"livestrategy is already running");
            return;
        }
        this.mIsRunning = true;
        Log.w((String)TAG, (String)"start livestrategy");
    }

    @Override
    @Nullable
    public void stop() {
    }

    @Override
    @Nullable
    public void setAppInfoBundle(IAppInfoBundle appInfoBundle) {
    }

    @Override
    @Nullable
    public void setRoomInfo(String roomInfo, int type, long arg1) {
    }

    @Override
    @Nullable
    public String getPreconnResult(String host) {
        return null;
    }

    @Override
    @Nullable
    public void setStreamInfo(String scene, String enterMethod, String streamInfo) {
    }

    @Override
    @Nullable
    public void setSupportSRScene(boolean supportSRScene) {
    }

    @Override
    @Nullable
    public <T> T getInfo(String key, @NonNull T defaultValue) {
        return null;
    }

    @Override
    @Nullable
    public void triggerSRPredict(JSONObject sessionInfo) {
    }

    @Override
    @Nullable
    public void stopSession(JSONObject sessionInfo) {
    }

    @Override
    @Nullable
    public void setIFunctionCalledByStrategyEngine(IFunctionCalledByStrategyEngine engine) {
    }

    @Override
    @Nullable
    public void setFunctionStartPTYInit(IFunctionStartPTYInit iFunctionStartPTYInit) {
    }

    @Override
    @Nullable
    public void doLocalDnsOperator(Context context) {
    }

    @Override
    @Nullable
    public void notifyInfo(int SDKType, int infoType, String info) {
    }

    @Override
    public String getConfigAndStrategyBundle(int SDKType, JSONObject sdkInfo) {
        return null;
    }

    @Override
    public <T> T getConfigAndStrategyByKeyStr(int SDKType, String key, @NonNull T defaultValue, JSONObject sdkInfo) {
        return null;
    }

    @Override
    public <T> T getConfigAndStrategyByKeyInt(int SDKType, int key, @NonNull T defaultValue, JSONObject sdkInfo) {
        return null;
    }

    @Override
    public void setFeatureDataBundle(String sessionID, IAppInfoBundle bundle) {
    }

    @Override
    public void releaseFeatureDataBundle(String sessionID) {
    }

    @Override
    public void setEventInfo(int eventName, JSONObject eventInfo) {
    }

    public void init(Context context, JSONObject initInfo) throws Exception {
        this.mContext = context;
        DataWarehouse.init(this.mContext);
    }

    static {
        mLoadLibraryTime = -1L;
        List<String> defaultLibrary = Arrays.asList("livestrategy");
        mLibraryList = new ArrayList<String>();
        mLibraryList.addAll(defaultLibrary);
        for (String library : mLibraryList) {
            mLoadSoSuccess = LiveStrategyManager.loadLibrary(library);
        }
    }
}

