/*
 * Decompiled with CFR 0.152.
 */
package com.ss.videoarch.strategy.network;

import android.util.Log;
import android.util.Pair;
import com.ss.videoarch.strategy.network.IHttpExecutor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

public class LSSDKConfig {
    static String TAG = "SettingsManager";
    final String mApiHost;
    final IHttpExecutor mHttpExecutor;
    final List<Pair<String, String>> mCommonParams;
    final ThreadPoolExecutor mCustomThreadPool;

    private LSSDKConfig(Builder builder) {
        this.mApiHost = builder.mApiHost;
        if (builder.mHttpExecutor == null) {
            this.mHttpExecutor = new DefaultHttpExecutor();
            Log.i((String)TAG, (String)"use DefaultHttpExecutor");
        } else {
            this.mHttpExecutor = builder.mHttpExecutor;
        }
        this.mCommonParams = builder.mCommonParams;
        this.mCustomThreadPool = builder.mCustomThreadPool;
    }

    private class DefaultHttpExecutor
    implements IHttpExecutor {
        private int SEND_REQUEST_TIMEOUT = 10;

        private DefaultHttpExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String executeGet(String urlPath) throws Exception {
            HttpURLConnection connection = this.getHttpURLConnection("GET", urlPath);
            if (connection == null) {
                Log.i((String)TAG, (String)"Get connection error");
                return null;
            }
            InputStream is = null;
            try {
                if (connection.getResponseCode() == 200) {
                    String line;
                    is = connection.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    String string = response.toString();
                    return string;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                    connection = null;
                }
                if (is != null) {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String executePost(String urlPath, byte[] data, String contentEncoding, String contentType) throws Exception {
            HttpURLConnection connection = this.getHttpURLConnection("POST", urlPath);
            if (connection == null) {
                Log.i((String)TAG, (String)"Post connection error");
                return null;
            }
            OutputStream os = null;
            InputStream is = null;
            try {
                os = connection.getOutputStream();
                os.write(data);
                if (connection.getResponseCode() == 200) {
                    String line;
                    is = connection.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    String string = response.toString();
                    return string;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (connection != null) {
                    connection.disconnect();
                    connection = null;
                }
            }
            return null;
        }

        private HttpURLConnection getHttpURLConnection(String HttpMethod, String urlPath) {
            HttpURLConnection connection = null;
            try {
                URL url = new URL(urlPath);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod(HttpMethod);
                connection.setUseCaches(false);
                connection.setConnectTimeout(this.SEND_REQUEST_TIMEOUT * 1000);
                connection.setReadTimeout(this.SEND_REQUEST_TIMEOUT * 1000);
                connection.setDoInput(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return connection;
        }
    }

    public static class Builder {
        private String mApiHost;
        private IHttpExecutor mHttpExecutor;
        private List<Pair<String, String>> mCommonParams = new ArrayList<Pair<String, String>>();
        private ThreadPoolExecutor mCustomThreadPool;

        public Builder setApiHost(String apiHost) {
            this.mApiHost = apiHost;
            return this;
        }

        public Builder setHttpExecutor(IHttpExecutor httpExecutor) {
            this.mHttpExecutor = httpExecutor;
            return this;
        }

        public Builder setCustomThreadPool(ThreadPoolExecutor customThreadPool) {
            this.mCustomThreadPool = customThreadPool;
            return this;
        }

        public Builder setCommonParams(List<Pair<String, String>> commonParams) {
            this.mCommonParams = commonParams;
            return this;
        }

        public LSSDKConfig build() {
            return new LSSDKConfig(this);
        }
    }
}

