/*
 * Decompiled with CFR 0.152.
 */
package com.ss.videoarch.strategy.dataCenter.strategyData;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.ss.videoarch.strategy.utils.CalledByNative;
import com.ss.videoarch.strategy.utils.JNINamespace;

@JNINamespace(value="jni")
public class DataWarehouse {
    private static final String TAG = "DataWarehouse";
    private Context mContext = null;
    private static SharedPreferences sharedPreferences;

    public static void init(Context context) {
        Log.d((String)TAG, (String)"init");
        DataWarehouse.getInstance().mContext = context;
    }

    @CalledByNative
    public String ReadFromDB(String tableName, String key) {
        String value = "";
        if (this.mContext == null) {
            Log.d((String)TAG, (String)"mContext == null");
            return value;
        }
        if (sharedPreferences == null) {
            sharedPreferences = this.mContext.getSharedPreferences(tableName, 0);
        }
        value = sharedPreferences.getString(key, "");
        Log.d((String)TAG, (String)("ReadFromDB: table:" + tableName + ", key:" + key + ", value len:" + value.length()));
        return value;
    }

    @CalledByNative
    public void WriteToDB(String tableName, String key, String value) {
        if (this.mContext == null) {
            Log.d((String)TAG, (String)"mContext == null");
            return;
        }
        if (sharedPreferences == null) {
            sharedPreferences = this.mContext.getSharedPreferences(tableName, 0);
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.apply();
        Log.d((String)TAG, (String)("WriteToDB: table:" + tableName + ", key:" + key + ", value len:" + value.length()));
    }

    @CalledByNative
    public static DataWarehouse getInstance() {
        return DataWarehouseInstance.mInstance;
    }

    private static class DataWarehouseInstance {
        private static final DataWarehouse mInstance = new DataWarehouse();

        private DataWarehouseInstance() {
        }
    }
}

