/*
 * Decompiled with CFR 0.152.
 */
package com.ss.videoarch.strategy.utils;

import android.text.TextUtils;
import android.util.Log;
import java.io.File;

public class LibraryLoader {
    private static Loader sLoader;
    private static final String TAG = "LibraryLoader";

    public static void setupLibraryLoader(Loader loader) {
        sLoader = loader;
    }

    public static void loadLibrary(String shortName) throws Exception {
        Loader loader = sLoader;
        if (TextUtils.isEmpty((CharSequence)shortName)) {
            throw new Exception("Invalid library name.");
        }
        if (loader != null) {
            Log.w((String)TAG, (String)("Loading [" + shortName + "] with external loader " + loader), null);
            loader.loadLibrary(shortName);
        } else {
            System.loadLibrary(shortName);
        }
    }

    public static void loadLibraryFromPath(String absolutionPath) throws Exception {
        Loader loader = sLoader;
        if (TextUtils.isEmpty((CharSequence)absolutionPath)) {
            throw new Exception("Invalid library name.");
        }
        File file = new File(absolutionPath);
        if (!file.exists()) {
            throw new Exception("Not found library '" + absolutionPath + "' file.");
        }
        if (loader != null) {
            Log.w((String)TAG, (String)("Loading [" + file.getAbsolutePath() + "] with external loader " + loader), null);
            loader.loadLibraryFromPath(file.getAbsolutePath());
        } else {
            System.load(file.getAbsolutePath());
        }
    }

    public static interface Loader {
        public void loadLibrary(String var1) throws Exception;

        public void loadLibraryFromPath(String var1) throws Exception;
    }
}

