/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.networkpredictor;

import android.util.Log;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictor;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictorAwemeListener;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictorAwemePredictor;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictorListener;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictorMLConfig;
import com.bytedance.vcloud.networkpredictor.ISpeedRecordOld;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorResultCollection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class AwemeSpeedPredictor
implements ISpeedPredictor,
ISpeedPredictorAwemeListener {
    public static final int SPEEDPREDICTOR_ALOG_DEFAULT = 4;
    public static final int SPEEDPREDICTOR_ALOG_INTELLIGENT = 5;
    private static final String TAG = "AwemeSpeedPredictor";
    private ISpeedPredictorAwemePredictor mAwemeRealPredictor = null;
    private ISpeedPredictorListener mSpeedPredictorListener = null;
    private Timer timer;

    public AwemeSpeedPredictor(ISpeedPredictorListener listener) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this.mSpeedPredictorListener = listener;
        Class<?> c = null;
        try {
            c = Class.forName("com.bytedance.vcloud.iesnetworkpredictnative.NetworkSpeedManager");
        }
        catch (ClassNotFoundException e) {
            Log.d((String)TAG, (String)"AwemeSpeedPredictor: No Class Find");
        }
        Method method = c.getMethod("getInstance", new Class[0]);
        if (method == null) {
            Log.d((String)TAG, (String)"AwemeSpeedPredictor: No Class GetInstance Method Find");
        }
        this.mAwemeRealPredictor = (ISpeedPredictorAwemePredictor)method.invoke(null, new Object[0]);
        if (this.mAwemeRealPredictor == null) {
            Log.d((String)TAG, (String)"AwemeSpeedPredictor: No instance Obj Produce");
        }
        this.mSpeedPredictorListener = listener;
    }

    public void setupAlgorithmTypeAndConfig(int type, ISpeedPredictorMLConfig speedMlConfig) {
        if (type == 4) {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.mAwemeRealPredictor.setSpeedAlgorithmType(4);
        } else if (type == 5) {
            this.mAwemeRealPredictor.setPredictorListener(this);
            this.mAwemeRealPredictor.configMlModel(speedMlConfig);
            this.mAwemeRealPredictor.setSpeedAlgorithmType(5);
            this.startCalculate();
        }
    }

    void startCalculate() {
        this.timer = new Timer("awemeSpeedPredictor");
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                AwemeSpeedPredictor.this.mAwemeRealPredictor.calculateSpeed();
            }
        }, 500L, 500L);
    }

    void stopCalculate() {
        this.timer.cancel();
    }

    @Override
    public String getVersion() {
        return "A1.6.3";
    }

    @Override
    public float getPredictSpeed() {
        return this.getPredictSpeed(0);
    }

    @Override
    public float getPredictSpeed(int mediaType) {
        return (float)this.mAwemeRealPredictor.getSpeed();
    }

    @Override
    public float getLastPredictConfidence() {
        return -1.0f;
    }

    @Override
    public float getAverageDownloadSpeed(int mediaType, int speed_type, boolean trigger) {
        return -1.0f;
    }

    @Override
    public Map<String, String> getDownloadSpeed(int mediaType) {
        return null;
    }

    @Override
    public void update(String recordStr, Map<String, Integer> streamIdMediaTypeMap) {
    }

    @Override
    public void update(long downloadBytes, long costTime, long timestamp) {
        if (costTime <= 0L) {
            return;
        }
        double speedInBPS = (double)downloadBytes * 8.0 / ((double)costTime / 1000.0);
        this.mAwemeRealPredictor.monitorVideoSpeed(speedInBPS, downloadBytes, costTime);
    }

    @Override
    public void update(ISpeedRecordOld record, Map<String, Integer> streamIdMediaTypeMap) {
    }

    @Override
    public void release() {
    }

    @Override
    public String getMultidimensionalPredictSpeeds() {
        return null;
    }

    @Override
    public String getMultidimensionalDownloadSpeeds() {
        return null;
    }

    @Override
    public SpeedPredictorResultCollection getMultidimensionalPredictSpeedsObj() {
        return null;
    }

    @Override
    public SpeedPredictorResultCollection getMultidimensionalDownloadSpeedsObj() {
        return null;
    }

    @Override
    public String getCountry() {
        return this.mSpeedPredictorListener.getCountry();
    }

    @Override
    public String getNetworkType() {
        return this.mSpeedPredictorListener.getNetworkType();
    }

    @Override
    public int getPhoneSignal() {
        return this.mSpeedPredictorListener.getPhoneSignal();
    }

    @Override
    public Object getIOExecutor() {
        return this.mSpeedPredictorListener.getIOExecutor();
    }

    @Override
    public boolean getDownFileState(String url, String dir, String fileName) throws Exception {
        return this.mSpeedPredictorListener.getDownFileState(url, dir, fileName);
    }

    @Override
    public String getFilesCachePath() {
        return this.mSpeedPredictorListener.getFilesCachePath();
    }

    @Override
    public void prepare() {
    }

    @Override
    public void close() {
    }

    @Override
    public void start() {
    }

    @Override
    public void setConfigInfo(Map featureList) {
    }

    @Override
    public void setSpeedQueueSize(int size) {
    }
}

