/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vodsetting;

import android.annotation.SuppressLint;
import android.content.Context;
import com.bytedance.vodsetting.Fetcher;
import com.bytedance.vodsetting.FetcherListener;
import com.bytedance.vodsetting.Log;
import com.bytedance.vodsetting.NetInterface;
import com.bytedance.vodsetting.SettingsListener;
import com.bytedance.vodsetting.Storage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.json.JSONArray;
import org.json.JSONObject;

public class SettingsManager {
    private static final String TAG = "Manager";
    private static final String LOCAL_CACHE_EXPIRE = "local_cache_expire";
    @SuppressLint(value={"StaticFieldLeak"})
    private static SettingsManager instance;
    private final ReentrantReadWriteLock mListenerLock = new ReentrantReadWriteLock();
    private final ArrayList<SettingsListener> mListeners = new ArrayList();
    private Context mContext = null;
    private Fetcher mFetcher = null;
    private final HashMap<String, Storage> mStorages = new HashMap();
    private boolean mUseCache = true;
    private long mExpire = 0L;
    private int mFetchInterval = 600;
    private long mVersion = 0L;
    private Timer mSchedule = null;
    private TimerTask mTask = null;
    private final long mLocalCacheExpire = 0L;

    private SettingsManager() {
        int type = 3;
        this.mStorages.put("vod", new Storage("vod", type));
        this.mStorages.put("mdl", new Storage("mdl", type));
        this.mStorages.put("upload", new Storage("upload", type));
        this.mStorages.put("common", new Storage("common", 2));
    }

    public static synchronized SettingsManager shareSettings() {
        if (instance == null) {
            instance = new SettingsManager();
        }
        return instance;
    }

    public SettingsManager setContext(Context context) {
        if (this.mContext == null) {
            this.mContext = context;
            this.mFetcher = new Fetcher(context.getApplicationContext(), new MyFetcherListener(this));
        }
        return this;
    }

    public SettingsManager setMaxRetryTimes(int times) {
        this.mFetcher.setMaxRetryTimes(times);
        return this;
    }

    public SettingsManager setFetchInterval(int interval) {
        this.mFetcher.setFetchInterval(interval);
        return this;
    }

    public SettingsManager setDebug(boolean isOpen) {
        this.mFetcher.setDebug(isOpen);
        Log.setDebugSwitch(isOpen);
        return this;
    }

    public SettingsManager setNet(NetInterface net) {
        this.mFetcher.setNet(net);
        return this;
    }

    public void addListener(SettingsListener listener) {
        if (listener == null) {
            return;
        }
        this.mListenerLock.writeLock().lock();
        this.mListeners.add(listener);
        this.mListenerLock.writeLock().unlock();
    }

    public void removeListener(SettingsListener listener) {
        if (listener == null) {
            return;
        }
        this.mListenerLock.writeLock().lock();
        this.mListeners.remove(listener);
        this.mListenerLock.writeLock().unlock();
    }

    public void loadLocal(final int modules) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if ((modules & 8) > 0) {
                    SettingsManager.this._loadLocalData("common");
                }
                if ((modules & 2) > 0) {
                    SettingsManager.this._loadLocalData("mdl");
                }
                if ((modules & 1) > 0) {
                    SettingsManager.this._loadLocalData("vod");
                }
                if ((modules & 4) > 0) {
                    SettingsManager.this._loadLocalData("upload");
                }
            }
        }).start();
    }

    public void loadLocalAndRefresh(final String module, boolean async) {
        if (async) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SettingsManager.this._loadLocalSettings(module, true);
                }
            }).start();
        } else {
            this._loadLocalSettings(module, true);
        }
    }

    public void refresh() {
        if (this.mFetcher != null) {
            this.mFetcher.fetch("all", null, true);
        }
    }

    public void refresh(String module) {
        if (this.mFetcher != null) {
            this.mFetcher.fetch(module, null, true);
        }
    }

    public void refresh(String module, String configKey) {
        if (this.mFetcher != null) {
            this.mFetcher.fetch(module, configKey, true);
        }
    }

    public void refreshIfNeed(String module) {
        if (this.mFetcher != null) {
            this.mFetcher.fetch(module, null, false);
        }
    }

    public String getVodString(String key, String dValue) {
        return this.getString("vod", key, dValue);
    }

    public long getVodLong(String key, long dValue) {
        return this.getLong("vod", key, dValue);
    }

    public int getVodInt(String key, int dValue) {
        return this.getInt("vod", key, dValue);
    }

    public JSONArray getVodJsonArray(String key) {
        return this.getJsonArray("vod", key);
    }

    public JSONObject getVodJsonObject(String key) {
        return this.getJsonObject("vod", key);
    }

    public String getMDLString(String key, String dValue) {
        return this.getString("mdl", key, dValue);
    }

    public long getMDLLong(String key, long dValue) {
        return this.getLong("mdl", key, dValue);
    }

    public int getMDLInt(String key, int dValue) {
        return this.getInt("mdl", key, dValue);
    }

    public JSONArray getMDLJsonArray(String key) {
        return this.getJsonArray("mdl", key);
    }

    public JSONObject getMDLJsonObject(String key) {
        return this.getJsonObject("mdl", key);
    }

    public String getUploadString(String key, String dValue) {
        return this.getString("upload", key, dValue);
    }

    public long getUploadLong(String key, long dValue) {
        return this.getLong("upload", key, dValue);
    }

    public int getUploadInt(String key, int dValue) {
        return this.getInt("upload", key, dValue);
    }

    public JSONArray getUploadJsonArray(String key) {
        return this.getJsonArray("upload", key);
    }

    public JSONObject getUploadJsonObject(String key) {
        return this.getJsonObject("upload", key);
    }

    public String getString(String module, String key, String dValue) {
        Storage storage = this.mStorages.get(module);
        return storage.getString(key, dValue);
    }

    public long getLong(String module, String key, long dValue) {
        Storage storage = this.mStorages.get(module);
        return storage.getLong(key, dValue);
    }

    public int getInt(String module, String key, int dValue) {
        Storage storage = this.mStorages.get(module);
        return storage.getInt(key, dValue);
    }

    public JSONArray getJsonArray(String module, String key) {
        return this.mStorages.get(module).getJsonArray(key);
    }

    public JSONObject getJsonObject(String module, String key) {
        Storage storage = this.mStorages.get(module);
        return storage.getJsonObject(key);
    }

    public void putCommonInt(String key, int value) {
        Storage storage = this.mStorages.get("common");
        storage.putInt(key, value);
    }

    public void putCommonLong(String key, long value) {
        Storage storage = this.mStorages.get("common");
        storage.putLong(key, value);
    }

    public void putCommonString(String key, String value) {
        Storage storage = this.mStorages.get("common");
        storage.putString(key, value);
    }

    public String getCommonString(String key, String dValue) {
        return this.getString("common", key, dValue);
    }

    public long getCommonLong(String key, long dValue) {
        return this.getLong("common", key, dValue);
    }

    public int getCommonInt(String key, int dValue) {
        return this.getInt("common", key, dValue);
    }

    public JSONObject getJsonObject(String module) {
        Storage storage = this.mStorages.get(module);
        return storage.getJsonObject();
    }

    private void _notifyListener(String module, int msg) {
        this.mListenerLock.readLock().lock();
        for (SettingsListener listener : this.mListeners) {
            listener.onNotify(module, msg);
        }
        this.mListenerLock.readLock().unlock();
    }

    private void _storeSettingsInfo(String module, String configKey, JSONObject jsonObject) {
        Storage storage;
        JSONObject oriJson;
        if (!(jsonObject == null || (oriJson = (storage = this.mStorages.get(module)).getJsonObject()) != null && oriJson.toString().equals(jsonObject.toString()))) {
            storage.storeJsonObject(jsonObject, configKey != null);
            this._notifyListener(module, 1000);
        }
    }

    private void _loadLocalData(String module) {
        Storage storage = this.mStorages.get(module);
        if (storage.tryToLoadLocal(this.mContext.getApplicationContext())) {
            if (this.mUseCache) {
                this._notifyListener(module, 1000);
            } else {
                storage.removeAllCache();
            }
        }
    }

    private synchronized void _loadLocalSettings(String module, boolean needFetch) {
        if (this.mExpire < 1L) {
            Storage commonStorage = this.mStorages.get("common");
            commonStorage.tryToLoadLocal(this.mContext.getApplicationContext());
            try {
                this.mFetchInterval = commonStorage.getInt("fetch_interval", 0);
                this.mVersion = commonStorage.getLong("config_version", 0L);
                this.mExpire = commonStorage.getLong(LOCAL_CACHE_EXPIRE, 0L);
                this.mUseCache = commonStorage.getInt("use_local_cache", 1) > 0;
            }
            catch (Throwable e) {
                Log.e(TAG, e.toString());
            }
            this._loadLocalData("vod");
            this._loadLocalData("mdl");
            this._loadLocalData("upload");
        }
        if (this.mFetcher != null) {
            this.mFetcher.setFetchInterval(this.mFetchInterval);
            this.mFetcher.setConfigVersion(this.mVersion);
        }
        if (needFetch) {
            long curTimeMs = System.currentTimeMillis();
            Log.v(TAG, "use cache: " + this.mUseCache + ", expire = " + this.mExpire + ", curTimeMs = " + curTimeMs);
            if (!this.mUseCache || this.mExpire <= curTimeMs) {
                this.refresh(module);
            }
        }
        this._scheduleEvent(this.mFetchInterval);
    }

    private synchronized void _scheduleEvent(long interval) {
        if (this.mTask != null) {
            this.mTask.cancel();
        }
        this.mTask = new TimerTask(){

            @Override
            public void run() {
                SettingsManager.this.refresh("all");
            }
        };
        if (this.mSchedule != null) {
            this.mSchedule.purge();
        } else {
            this.mSchedule = new Timer(true);
        }
        if (interval * 1000L < 1000L) {
            interval = 86400L;
        }
        Log.v(TAG, "reset schedule");
        try {
            this.mSchedule.schedule(this.mTask, interval * 1000L, interval * 1000L);
        }
        catch (Throwable e) {
            Log.e(TAG, "reset schedule fail. " + e.toString());
            e.printStackTrace();
        }
    }

    private class MyFetcherListener
    implements FetcherListener {
        private final WeakReference<SettingsManager> mManager;

        MyFetcherListener(SettingsManager manager) {
            this.mManager = new WeakReference<SettingsManager>(manager);
        }

        @Override
        public void onResult(int code, String msg, JSONObject data) {
            this.onResult(code, msg, data, null, null);
        }

        @Override
        public void onResult(int code, String msg, JSONObject data, String module, String configKey) {
            JSONObject customSettings;
            SettingsManager manager = (SettingsManager)this.mManager.get();
            if (manager == null) {
                return;
            }
            Log.v(SettingsManager.TAG, "refresh settings: code " + code + ", message = " + msg);
            if (code != 0) {
                Log.e(SettingsManager.TAG, "refresh data fail. code = " + code);
                return;
            }
            JSONObject generalSettings = data.optJSONObject("general_settings");
            if (generalSettings != null) {
                boolean useLocalCache;
                long localCacheDuration;
                long version = generalSettings.optLong("config_version");
                manager.mFetcher.setConfigVersion(version);
                Storage storage = (Storage)SettingsManager.this.mStorages.get("common");
                storage.putLong("config_version", version);
                int interval = generalSettings.optInt("fetch_interval");
                if (interval > 0 && interval != storage.getInt("fetch_interval", -1)) {
                    storage.putInt("fetch_interval", interval);
                    manager.mFetcher.setFetchInterval(interval);
                    SettingsManager.this._scheduleEvent(interval);
                }
                if ((localCacheDuration = generalSettings.optLong(SettingsManager.LOCAL_CACHE_EXPIRE)) > 0L) {
                    long expire = System.currentTimeMillis() + localCacheDuration * 1000L;
                    storage.putLong(SettingsManager.LOCAL_CACHE_EXPIRE, expire);
                }
                storage.putInt("use_local_cache", (useLocalCache = generalSettings.optBoolean("use_local_cache")) ? 1 : 0);
                if (!useLocalCache) {
                    ((Storage)SettingsManager.this.mStorages.get("vod")).removeAllCache();
                    ((Storage)SettingsManager.this.mStorages.get("mdl")).removeAllCache();
                    ((Storage)SettingsManager.this.mStorages.get("upload")).removeAllCache();
                }
            }
            if ((customSettings = data.optJSONObject("custom_settings")) != null) {
                if (module != null && !module.equals("all")) {
                    SettingsManager.this._storeSettingsInfo(module, configKey, customSettings.optJSONObject(module));
                } else {
                    SettingsManager.this._storeSettingsInfo("vod", configKey, customSettings.optJSONObject("vod"));
                    SettingsManager.this._storeSettingsInfo("mdl", configKey, customSettings.optJSONObject("mdl"));
                    SettingsManager.this._storeSettingsInfo("upload", configKey, customSettings.optJSONObject("upload"));
                }
            }
        }
    }
}

