/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.networkspeed;

import com.ss.android.ugc.networkspeed.NetworkSpeedManager;
import com.ss.android.ugc.networkspeed.SpeedRecord;
import java.util.Queue;

public class AverageSpeedAlgorithm
implements NetworkSpeedManager.SpeedAlgorithm {
    private double speed = -1.0;

    @Override
    public double getSpeed(Queue<SpeedRecord> speedRecordQueue, SpeedRecord[] buffer) {
        return this.calculate(speedRecordQueue, buffer);
    }

    @Override
    public double calculate(Queue<SpeedRecord> speedRecordQueue, SpeedRecord[] buffer) {
        if (speedRecordQueue.size() < 1) {
            return -1.0;
        }
        speedRecordQueue.toArray(buffer);
        double result = -1.0;
        int bytes = 0;
        long time = 0L;
        for (int i = 0; i < speedRecordQueue.size(); ++i) {
            bytes = (int)((double)bytes + buffer[i].mWeight);
            time += buffer[i].mCostTime;
        }
        result = (double)bytes * 8.0 / ((double)time / 1000.0);
        if (result < 0.0) {
            throw new IllegalArgumentException();
        }
        this.speed = result;
        return result;
    }
}

