/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.networkspeed;

import com.ss.android.ugc.networkspeed.NetworkSpeedManager;
import com.ss.android.ugc.networkspeed.SpeedRecord;
import java.util.Arrays;
import java.util.Queue;

public class DefaultSpeedAlgorithm
implements NetworkSpeedManager.SpeedAlgorithm {
    private double speed = -1.0;

    @Override
    public double getSpeed(Queue<SpeedRecord> speedRecordQueue, SpeedRecord[] buffer) {
        return this.calculate(speedRecordQueue, buffer);
    }

    @Override
    public double calculate(Queue<SpeedRecord> speedRecordQueue, SpeedRecord[] buffer) {
        if (speedRecordQueue.size() < 1) {
            return -1.0;
        }
        speedRecordQueue.toArray(buffer);
        Arrays.sort(buffer, 0, speedRecordQueue.size());
        int start = 0;
        int end = speedRecordQueue.size();
        double targetWeight = 0.0;
        for (int i = start; i < end; ++i) {
            targetWeight += buffer[i].mWeight;
        }
        targetWeight /= 2.0;
        double result = -1.0;
        for (int i = start; i < end; ++i) {
            if (!((targetWeight -= buffer[i].mWeight) <= 0.0)) continue;
            result = buffer[i].mSpeed;
            break;
        }
        if (result < 0.0) {
            throw new IllegalArgumentException();
        }
        this.speed = result;
        return result;
    }
}

