/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.DataLoaderResourceProvider;
import com.ss.ttvideoengine.FeatureManager;
import com.ss.ttvideoengine.IPreLoaderItemCallBackListener;
import com.ss.ttvideoengine.source.DirectUrlSource;
import com.ss.ttvideoengine.source.strategy.CodecStrategy;
import com.ss.ttvideoengine.source.strategy.CodecStrategyAdapter;
import com.ss.ttvideoengine.utils.EngineException;
import java.util.HashMap;

public class PreloaderURLItem {
    private static final String TAG = "PreloaderURLItem";
    @Nullable
    private String mKey = null;
    @Nullable
    private String mFilePath = null;
    @Nullable
    private String mVideoId = null;
    private String mTag = "";
    private String mSubTag = "";
    private long mPreloadSize = 0L;
    private long mPreloadFooterSize = 0L;
    private int mCdnType;
    private int mPriorityLevel = 0;
    @Nullable
    private String[] mUrls = null;
    @Nullable
    private DataLoaderResourceProvider mProvider = null;
    @Nullable
    private IPreLoaderItemCallBackListener mCallBackListener = null;
    @Nullable
    private HashMap<String, String> mHeaders = null;
    public CodecStrategyAdapter mAdapter;

    @Nullable
    public String[] getUrls() {
        return this.mUrls;
    }

    @Nullable
    public String getVideoId() {
        return this.mVideoId;
    }

    public void setKey(@Nullable String mKey) {
        this.mKey = mKey;
    }

    public void setTag(String tag) {
        this.mTag = tag;
    }

    public String getTag() {
        return this.mTag;
    }

    public void setSubTag(String subTag) {
        this.mSubTag = subTag;
    }

    public String getSubTag() {
        return this.mSubTag;
    }

    @Nullable
    public String getKey() {
        return this.mKey;
    }

    @Nullable
    public String getFilePath() {
        return this.mFilePath;
    }

    public long getPreloadSize() {
        return this.mPreloadSize;
    }

    public int getCdnType() {
        return this.mCdnType;
    }

    public void setCdnType(int cdnType) {
        if (FeatureManager.hasPermission("pcdn")) {
            this.mCdnType = cdnType;
        }
    }

    public PreloaderURLItem(String key, @Nullable String videoId, long preloadSize, String[] urls, String cacheDir) {
        this.mKey = key;
        this.mVideoId = videoId;
        this.mPreloadSize = preloadSize;
        this.mUrls = urls;
        this.mFilePath = cacheDir;
    }

    public PreloaderURLItem(String key, @Nullable String videoId, long preloadSize, String[] urls) {
        this.mKey = key;
        this.mVideoId = videoId;
        this.mPreloadSize = preloadSize;
        this.mUrls = urls;
    }

    public PreloaderURLItem(@Nullable String videoId, long preloadSize, String[] urls, String filePath) {
        this.mFilePath = filePath;
        this.mVideoId = videoId;
        this.mPreloadSize = preloadSize;
        this.mUrls = urls;
    }

    public void setPreloadFooterSize(long preloadFooterSize) {
        this.mPreloadFooterSize = preloadFooterSize;
    }

    public long getPreloadFooterSize() {
        return this.mPreloadFooterSize;
    }

    public PreloaderURLItem(@NonNull DirectUrlSource source, long preloadSize) {
        this.mVideoId = source.vid();
        this.mPreloadSize = preloadSize;
        this.mAdapter = new CodecStrategyAdapter(new CodecStrategyAdapter.PreloadSourceSetter(){

            @Override
            public void setDirectUrl(String vid, DirectUrlSource.UrlItem urlItem, @Nullable CodecStrategy.Dimension dimension, boolean isFetchSmartUrl) {
                CodecStrategyAdapter.PreloadSourceSetter.super.setDirectUrl(vid, urlItem, dimension, isFetchSmartUrl);
                PreloaderURLItem.this.mKey = urlItem.getCacheKey();
                PreloaderURLItem.access$102(PreloaderURLItem.this, new String[]{urlItem.getUrl()});
            }
        });
        try {
            this.mAdapter.setStrategySource(source);
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
    }

    public PreloaderURLItem(String key, @Nullable String videoId, long preloadSize, DataLoaderResourceProvider provider, String cacheDir) {
        this.mProvider = provider;
        this.mVideoId = videoId;
        this.mPreloadSize = preloadSize;
        this.mKey = key;
        this.mFilePath = cacheDir;
    }

    public void setPriorityLevel(int priorityLevel) {
        this.mPriorityLevel = priorityLevel;
    }

    public int getPriorityLevel() {
        return this.mPriorityLevel;
    }

    @Nullable
    public IPreLoaderItemCallBackListener getCallBackListener() {
        return this.mCallBackListener;
    }

    public void setCallBackListener(@Nullable IPreLoaderItemCallBackListener listener) {
        this.mCallBackListener = listener;
    }

    public void setCustomHeader(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (this.mHeaders == null) {
            this.mHeaders = new HashMap();
        }
        this.mHeaders.put(key.substring(0, 1).toUpperCase() + key.substring(1), value);
    }

    public HashMap<String, String> customHeaders() {
        return this.mHeaders;
    }

    public void setProvider(@Nullable DataLoaderResourceProvider mProvider) {
        this.mProvider = mProvider;
    }

    @Nullable
    public DataLoaderResourceProvider getProvider() {
        return this.mProvider;
    }

    static /* synthetic */ String[] access$102(PreloaderURLItem x0, String[] x1) {
        x0.mUrls = x1;
        return x1;
    }
}

