/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.FeatureManager;
import com.ss.ttvideoengine.IPreLoaderItemCallBackListener;
import com.ss.ttvideoengine.PreloaderFilePathListener;
import com.ss.ttvideoengine.PreloaderVidItemFetchListener;
import com.ss.ttvideoengine.PreloaderVidItemListener;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.TTVideoEngineConfig;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.source.VidPlayAuthTokenSource;
import com.ss.ttvideoengine.source.strategy.CodecStrategy;
import com.ss.ttvideoengine.source.strategy.CodecStrategyAdapter;
import com.ss.ttvideoengine.utils.EngineException;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PreloaderVidItem {
    private static final String TAG = "PreloaderVidItem";
    public String mVideoId = null;
    public Resolution mResolution = Resolution.SuperHigh;
    public long mPreloadSize = 0L;
    public int mApiVersion = 0;
    public String mCodecType = "h264";
    public boolean mDashEnable = false;
    public boolean mHttpsEnable = false;
    public boolean mForbidP2p = false;
    public boolean mBoeEnable = false;
    public Map<Integer, String> mParams = null;
    public boolean mHlsEnable = false;
    public boolean mEncryptEnable = false;
    public int mCdnType;
    public int mPriorityLevel = 0;
    private String mAuthorization = null;
    private boolean mOnlyFetchVideoModel = false;
    public HashMap<String, Resolution> mResolutionMap;
    private TTVNetClient mNetClient = null;
    public PreloaderVidItemListener mListener = null;
    private PreloaderVidItemFetchListener mFetchEndListener = null;
    private PreloaderFilePathListener mFilePathListener = null;
    private String mTag = "";
    private String mSubTag = "";
    @Nullable
    private IPreLoaderItemCallBackListener mCallBackListener = null;
    public CodecStrategyAdapter mAdapter;

    public PreloaderVidItem(String vid, String authorization, Resolution resolution, long preloadSize, boolean ish265) {
        this.mVideoId = vid;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        if (ish265) {
            this.mCodecType = "h265";
        }
        this.setAuthorization(authorization);
    }

    public PreloaderVidItem(String vid, String authorization, Resolution resolution, long preloadSize, String codecType) {
        this.mVideoId = vid;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        this.mCodecType = codecType;
        this.setAuthorization(authorization);
    }

    public PreloaderVidItem(String vid, String authorization, boolean onlyFetchVideoModel) {
        this.mVideoId = vid;
        this.setAuthorization(authorization);
        this.mOnlyFetchVideoModel = onlyFetchVideoModel;
    }

    public PreloaderVidItem(VidPlayAuthTokenSource source, long preloadSize) {
        this.mVideoId = source.vid();
        this.mResolution = source.resolution();
        this.mPreloadSize = preloadSize;
        this.mAdapter = new CodecStrategyAdapter(new CodecStrategyAdapter.PreloadSourceSetter(){

            @Override
            public void setVideoID(String vid, String playAuthToken, @Nullable CodecStrategy.Dimension dimension) {
                CodecStrategyAdapter.PreloadSourceSetter.super.setVideoID(vid, playAuthToken, dimension);
                PreloaderVidItem.this.mVideoId = vid;
                PreloaderVidItem.this.setAuthorization(playAuthToken);
                PreloaderVidItem.this.mCodecType = dimension != null ? dimension.encodeType : null;
            }
        });
        try {
            this.mAdapter.setStrategySource(source);
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
    }

    public void setAuthorization(String authorization) {
        TTVideoEngineLog.d(TAG, "setAuthorization:" + authorization);
        String authStr = TTHelper.base64Decode(authorization);
        String tokenVersion = "";
        if (!TextUtils.isEmpty((CharSequence)authStr)) {
            try {
                JSONObject authJSON = new JSONObject(authStr);
                this.mAuthorization = authJSON.optString("GetPlayInfoToken");
                if (TextUtils.isEmpty((CharSequence)this.mAuthorization)) {
                    this.mAuthorization = authStr;
                }
                tokenVersion = authJSON.optString("TokenVersion");
            }
            catch (JSONException e) {
                e.printStackTrace();
                this.mAuthorization = authStr;
            }
        }
        this.mApiVersion = !TextUtils.isEmpty((CharSequence)tokenVersion) && tokenVersion.equals("V2") ? 4 : 2;
    }

    public PreloaderVidItem(String vid, Resolution resolution, long preloadSize, boolean ish265) {
        this.mVideoId = vid;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        if (ish265) {
            this.mCodecType = "h265";
        }
    }

    public PreloaderVidItem(String vid, Resolution resolution, long preloadSize, String codecType) {
        this.mVideoId = vid;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        this.mCodecType = codecType;
    }

    public PreloaderVidItem(String vid, Resolution resolution, long preloadSize, boolean ish265, boolean forbidP2p) {
        this.mVideoId = vid;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        if (ish265) {
            this.mCodecType = "h265";
        }
        this.mForbidP2p = forbidP2p;
    }

    public PreloaderVidItem(String vid, Resolution resolution, long preloadSize, String codecType, boolean forbidP2p) {
        this.mVideoId = vid;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        this.mCodecType = codecType;
        this.mForbidP2p = forbidP2p;
    }

    String getAuthorization() {
        return this.mAuthorization;
    }

    public void setResolutionMap(HashMap<String, Resolution> resolutionMap) {
        if (resolutionMap == null || resolutionMap.size() <= 0) {
            return;
        }
        this.mResolutionMap = resolutionMap;
    }

    public void setTag(String tag) {
        this.mTag = tag;
    }

    public String getTag() {
        return this.mTag;
    }

    public void setSubTag(String subTag) {
        this.mSubTag = subTag;
    }

    public String getSubTag() {
        return this.mSubTag;
    }

    public void setPriorityLevel(int priority) {
        this.mPriorityLevel = priority;
    }

    public int getPriorityLevel() {
        return this.mPriorityLevel;
    }

    public void setCallBackListener(@Nullable IPreLoaderItemCallBackListener listener) {
        this.mCallBackListener = listener;
    }

    public void setOnlyFetchVideoModel(boolean only) {
        this.mOnlyFetchVideoModel = only;
    }

    boolean getOnlyFetchVideoModel() {
        return this.mOnlyFetchVideoModel;
    }

    @Nullable
    public IPreLoaderItemCallBackListener getCallBackListener() {
        return this.mCallBackListener;
    }

    public void setFilePathListener(PreloaderFilePathListener listener) {
        this.mFilePathListener = listener;
    }

    PreloaderFilePathListener getFilePathListener() {
        return this.mFilePathListener;
    }

    public void setNetworkClient(TTVNetClient client) {
        this.mNetClient = client;
    }

    public TTVNetClient getNetClient() {
        if (this.mNetClient != null) {
            return this.mNetClient;
        }
        if (TTVideoEngineConfig.gNetClient != null) {
            return TTVideoEngineConfig.gNetClient;
        }
        return null;
    }

    public void setFetchEndListener(PreloaderVidItemFetchListener mListener) {
        this.mFetchEndListener = mListener;
    }

    PreloaderVidItemFetchListener getFetchEndListener() {
        return this.mFetchEndListener;
    }

    public void setListener(PreloaderVidItemListener mListener) {
        this.mListener = mListener;
    }

    public PreloaderVidItemListener getListener() {
        return this.mListener;
    }

    public int getCdnType() {
        return this.mCdnType;
    }

    public void setCdnType(int cdnType) {
        if (FeatureManager.hasPermission("pcdn")) {
            this.mCdnType = cdnType;
        }
    }
}

