/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.os.SystemClock;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictor;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.DataLoaderListener;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.utils.DataLoaderCDNLog;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

public class TTDataLoaderDefaultListener
implements DataLoaderListener {
    private static final String TAG = "TTVideoEngine";
    private ISpeedPredictor mPredictor;
    private DataLoaderListener mInjectDataLoaderListener;

    TTDataLoaderDefaultListener(ISpeedPredictor predictor, DataLoaderListener listener) {
        this.mPredictor = predictor;
        this.mInjectDataLoaderListener = listener;
    }

    @Override
    public String apiStringForFetchVideoModel(Map<String, String> param, String videoId, Resolution resolution) {
        if (this.mInjectDataLoaderListener != null) {
            return this.mInjectDataLoaderListener.apiStringForFetchVideoModel(param, videoId, resolution);
        }
        return null;
    }

    @Override
    public String authStringForFetchVideoModel(String videoId, Resolution resolution) {
        if (this.mInjectDataLoaderListener != null) {
            return this.mInjectDataLoaderListener.authStringForFetchVideoModel(videoId, resolution);
        }
        return null;
    }

    @Override
    public void dataLoaderError(String videoId, int errorType, Error error) {
        if (this.mInjectDataLoaderListener != null) {
            this.mInjectDataLoaderListener.dataLoaderError(videoId, errorType, error);
        }
    }

    @Override
    public void onNotify(int what, long code, long parameter, String info) {
        if (what == 2 && this.mPredictor != null) {
            this.mPredictor.update(code, parameter, SystemClock.elapsedRealtime());
            if (parameter != 0L) {
                TTVideoEngineLog.d(TAG, String.format(Locale.US, "[IESSpeedPredictor]: speedRecord:%f", (double)code / (double)parameter));
            }
        }
        if (this.mInjectDataLoaderListener != null) {
            this.mInjectDataLoaderListener.onNotify(what, code, parameter, info);
        }
    }

    @Override
    public void onLogInfo(int what, String logType, JSONObject log) {
        if (this.mInjectDataLoaderListener != null) {
            this.mInjectDataLoaderListener.onLogInfo(what, logType, log);
        }
    }

    @Override
    public void onTaskProgress(DataLoaderHelper.DataLoaderTaskProgressInfo progressInfo) {
        if (this.mInjectDataLoaderListener != null) {
            this.mInjectDataLoaderListener.onTaskProgress(progressInfo);
        }
    }

    @Override
    public void onNotifyCDNLog(DataLoaderCDNLog log) {
        if (this.mInjectDataLoaderListener != null) {
            this.mInjectDataLoaderListener.onNotifyCDNLog(log);
        }
    }

    @Override
    public void onNotifyCDNLog(JSONObject log) {
        if (this.mInjectDataLoaderListener != null) {
            this.mInjectDataLoaderListener.onNotifyCDNLog(log);
        }
    }

    @Override
    public String getCheckSumInfo(String fileKey) {
        if (this.mInjectDataLoaderListener != null) {
            return this.mInjectDataLoaderListener.getCheckSumInfo(fileKey);
        }
        return null;
    }

    @Override
    public boolean loadLibrary(String name) {
        if (this.mInjectDataLoaderListener != null) {
            return this.mInjectDataLoaderListener.loadLibrary(name);
        }
        return false;
    }

    @Override
    public void onLogInfoToMonitor(int what, String logType, JSONObject log) {
        if (this.mInjectDataLoaderListener != null) {
            this.mInjectDataLoaderListener.onLogInfoToMonitor(what, logType, log);
        }
    }

    @Override
    public void onLoadProgress(DataLoaderHelper.DataLoaderTaskLoadProgress loadProgress) {
        if (this.mInjectDataLoaderListener != null) {
            this.mInjectDataLoaderListener.onLoadProgress(loadProgress);
        }
    }

    @Override
    public HashMap<String, String> getCustomHttpHeaders(String url) {
        if (this.mInjectDataLoaderListener != null) {
            this.mInjectDataLoaderListener.getCustomHttpHeaders(url);
        }
        return null;
    }
}

